/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.common.crawl.client.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.beastguy.distantlandsmc.common.crawl.Crawl;
import net.beastguy.distantlandsmc.common.crawl.client.CrawlClient;
import net.beastguy.distantlandsmc.common.crawl.client.mixininterface.CrawlingState;
import net.beastguy.distantlandsmc.common.crawl.mixininterface.PrevPoseState;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    PlayerRendererMixin() {
        super(null, null, 0.0f);
    }

    @Inject(method={"setModelProperties"}, at={@At(value="TAIL")})
    void onUpdateRenderState(AbstractClientPlayer e, CallbackInfo ci) {
        boolean crawling = e.getPose() == Crawl.Shared.CRAWLING || e.getSwimAmount(0.0f) > 0.0f && ((PrevPoseState)e).getPrevPose() == Crawl.Shared.CRAWLING;
        ((CrawlingState)this.getModel()).setCrawling(CrawlClient.replaceAnimation ? crawling : false);
        ((PlayerModel)this.getModel()).crouching = ((PlayerModel)this.getModel()).crouching & !crawling;
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;getSwimAmount(F)F")})
    float rotateWhenCrawlingSameWayAsWhenSwimming(float swimAmount) {
        if (CrawlClient.replaceAnimation && ((CrawlingState)this.getModel()).isCrawling()) {
            swimAmount += 1.0E-4f;
        }
        return swimAmount;
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;isVisuallySwimming()Z")})
    boolean applyXRotationWhenCrawling(boolean isVisuallySwimming) {
        return CrawlClient.replaceAnimation && ((CrawlingState)this.getModel()).isCrawling() || isVisuallySwimming;
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="CONSTANT", args={"floatValue=-1.0F"})})
    float smootherYOffsetSwimmingPosTransition(float original, @Local AbstractClientPlayer state, @Local(ordinal=2) float pt) {
        return Mth.lerp((float)state.getSwimAmount(pt), (float)0.0f, (float)original);
    }

    @ModifyExpressionValue(method={"setupRotations"}, at={@At(value="CONSTANT", args={"floatValue=0.3F"})})
    float smootherZOffsetSwimmingPosTransition(float original, @Local AbstractClientPlayer state, @Local(ordinal=2) float pt) {
        return Mth.lerp((float)state.getSwimAmount(pt), (float)0.0f, (float)(original - 0.1f));
    }
}

