/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.common.crawl.compat.fpm.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.tr7zw.firstperson.LogicHandler;
import net.beastguy.distantlandsmc.common.crawl.Crawl;
import net.beastguy.distantlandsmc.common.crawl.mixininterface.PrevPoseState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LogicHandler.class}, remap=false)
public class LogicHandlerMixin {
    @Shadow
    private Vec3 offset;

    @Unique
    private boolean isCrawling(Player player, float delta) {
        return player.getPose() == Crawl.Shared.CRAWLING || player.getSwimAmount(0.0f) > 0.0f && ((PrevPoseState)player).getPrevPose() == Crawl.Shared.CRAWLING;
    }

    @ModifyReturnValue(method={"isCrawlingOrSwimming"}, at={@At(value="RETURN")}, remap=false)
    private boolean isCrawlingOrSwimming(boolean original, Player player) {
        return original || this.isCrawling(player, 0.0f);
    }

    @ModifyExpressionValue(method={"updatePositionOffset"}, at={@At(value="INVOKE", target="Ldev/tr7zw/firstperson/LogicHandler;isCrawlingOrSwimming(Lnet/minecraft/world/entity/player/Player;)Z")}, remap=false)
    private boolean cancelDefaultCrawlOffset(boolean original, Entity entiy, float delta) {
        return original && !this.isCrawling((Player)entiy, delta);
    }

    @Inject(method={"updatePositionOffset"}, at={@At(value="TAIL")}, remap=false)
    private void applyCrawlOffset(Entity entiy, float delta, CallbackInfo ci) {
        Player player;
        if (entiy instanceof Player && this.isCrawling(player = (Player)entiy, delta)) {
            double yaw = Mth.rotLerp((float)delta, (float)player.yBodyRotO, (float)player.yBodyRot);
            float a = ((Player)entiy).getSwimAmount(delta);
            float offset = (float)Mth.lerp((double)a, (double)0.0, (double)((double)0.4f + (Math.sin(((double)a * Math.PI - 0.7853981633974483) * 2.0) + 1.0) / 2.0 * 0.5));
            this.offset = new Vec3(this.offset.x + (double)offset * Math.sin(Math.toRadians(yaw)), this.offset.y, this.offset.z - (double)offset * Math.cos(Math.toRadians(yaw)));
        }
    }
}

