/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.common.crawl.mixin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.beastguy.distantlandsmc.common.crawl.Crawl;
import net.beastguy.distantlandsmc.common.crawl.mixininterface.PrevPoseState;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PrevPoseState {
    @Shadow
    @Final
    private Abilities abilities;
    @Shadow
    @Final
    @Mutable
    private static Map<Pose, EntityDimensions> POSES;
    @Unique
    Pose prevPose;
    @Unique
    Pose prevTickPose;

    PlayerMixin() {
        super(null, null);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void onDefineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(Crawl.Shared.CRAWL_REQUEST, (Object)false);
    }

    @ModifyArg(method={"updatePlayerPose"}, at=@At(value="INVOKE", target="net/minecraft/world/entity/player/Player.setPose(Lnet/minecraft/world/entity/Pose;)V"))
    private Pose onPreUpdatePlayerPose(Pose pose) {
        if (!(this.isSpectator() || this.isPassenger() || this.abilities.flying)) {
            boolean swimming;
            boolean requested = (Boolean)this.getEntityData().get(Crawl.Shared.CRAWL_REQUEST);
            boolean bl = swimming = this.isSwimming() || this.isInWater();
            if (requested) {
                pose = swimming ? Pose.SWIMMING : Crawl.Shared.CRAWLING;
            } else if (pose == Pose.SWIMMING && !swimming) {
                pose = Crawl.Shared.CRAWLING;
            }
        }
        return pose;
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void onPoseMapCreation(CallbackInfo ci) {
        POSES = ImmutableMap.builder().putAll(POSES).put((Object)Crawl.Shared.CRAWLING, (Object)Crawl.Shared.CRAWLING_DIMENSIONS).build();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTickEnd(CallbackInfo ci) {
        if (this.getPose() != this.prevTickPose) {
            this.prevPose = this.prevTickPose;
        }
        this.prevTickPose = this.getPose();
    }

    @Override
    public Pose getPrevPose() {
        return this.prevPose;
    }
}

