/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.compat;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.beastguy.distantlandsmc.compat.CarpenterTableCategory;
import net.beastguy.distantlandsmc.recipe.CarpenterTableRecipe;
import net.beastguy.distantlandsmc.recipe.ModRecipeTypes;
import net.beastguy.distantlandsmc.screen.custom.CarpenterTableScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIDistantLandsPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CarpenterTableCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            RecipeManager recipeManager = mc.level.getRecipeManager();
            List<CarpenterTableRecipe> carpenterTableRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CARPENTER_TABLE_TYPE.get()).stream().map(RecipeHolder::value).toList();
            registration.addRecipes(CarpenterTableCategory.CARPENTER_TABLE_RECIPE_RECIPE_TYPE, carpenterTableRecipes);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CarpenterTableScreen.class, 70, 30, 25, 20, new RecipeType[]{CarpenterTableCategory.CARPENTER_TABLE_RECIPE_RECIPE_TYPE});
    }
}

