/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.datagen;

import java.util.LinkedHashMap;
import net.beastguy.distantlandsmc.block.ModBlocks;
import net.beastguy.distantlandsmc.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "distantlandsmc", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)ModItems.CHAINSAW.get());
        this.handheldItem(ModItems.EMERALD_SWORD);
        this.handheldItem(ModItems.EMERALD_PICKAXE);
        this.handheldItem(ModItems.EMERALD_AXE);
        this.handheldItem(ModItems.EMERALD_SHOVEL);
        this.handheldItem(ModItems.EMERALD_HOE);
        this.handheldItem(ModItems.RUBY_SWORD);
        this.handheldItem(ModItems.RUBY_PICKAXE);
        this.handheldItem(ModItems.RUBY_AXE);
        this.handheldItem(ModItems.RUBY_SHOVEL);
        this.handheldItem(ModItems.RUBY_HOE);
        this.handheldItem(ModItems.RUBY_HAMMER);
        this.trimmedArmorItem(ModItems.EMERALD_HELMET);
        this.trimmedArmorItem(ModItems.EMERALD_CHESTPLATE);
        this.trimmedArmorItem(ModItems.EMERALD_LEGGINGS);
        this.trimmedArmorItem(ModItems.EMERALD_BOOTS);
        this.trimmedArmorItem(ModItems.RUBY_HELMET);
        this.trimmedArmorItem(ModItems.RUBY_CHESTPLATE);
        this.trimmedArmorItem(ModItems.RUBY_LEGGINGS);
        this.trimmedArmorItem(ModItems.RUBY_BOOTS);
        this.trimmedArmorItem(ModItems.CURSED_RUBY_HELMET);
        this.trimmedArmorItem(ModItems.CURSED_RUBY_CHESTPLATE);
        this.trimmedArmorItem(ModItems.CURSED_RUBY_LEGGINGS);
        this.trimmedArmorItem(ModItems.CURSED_RUBY_BOOTS);
        this.basicItem((Item)ModItems.EMERALD_HORSE_ARMOR.get());
        this.basicItem((Item)ModItems.RUBY_HORSE_ARMOR.get());
        this.flowerItem(ModBlocks.PETUNIA);
        this.saplingItem(ModBlocks.HARU_SAPLING);
        this.saplingItem(ModBlocks.JACARANDA_SAPLING);
        this.saplingItem(ModBlocks.PAU_BRASIL_SAPLING);
        this.saplingItem(ModBlocks.IPE_AMARELO_SAPLING);
        this.basicItem((Item)ModItems.RUBY.get());
        this.basicItem((Item)ModItems.CURSED_RUBY.get());
        this.buttonItem(ModBlocks.HARU_BUTTON, ModBlocks.HARU_PLANKS);
        this.fenceItem(ModBlocks.HARU_FENCE, ModBlocks.HARU_PLANKS);
        this.basicItem(ModBlocks.HARU_DOOR.asItem());
        this.basicItem((Item)ModItems.HARU_SIGN.get());
        this.basicItem((Item)ModItems.HARU_HANGING_SIGN.get());
        this.buttonItem(ModBlocks.JACARANDA_BUTTON, ModBlocks.JACARANDA_PLANKS);
        this.fenceItem(ModBlocks.JACARANDA_FENCE, ModBlocks.JACARANDA_PLANKS);
        this.basicItem(ModBlocks.JACARANDA_DOOR.asItem());
        this.basicItem((Item)ModItems.JACARANDA_SIGN.get());
        this.basicItem((Item)ModItems.JACARANDA_HANGING_SIGN.get());
        this.buttonItem(ModBlocks.PAU_BRASIL_BUTTON, ModBlocks.PAU_BRASIL_PLANKS);
        this.fenceItem(ModBlocks.PAU_BRASIL_FENCE, ModBlocks.PAU_BRASIL_PLANKS);
        this.basicItem(ModBlocks.PAU_BRASIL_DOOR.asItem());
        this.basicItem((Item)ModItems.PAU_BRASIL_SIGN.get());
        this.basicItem((Item)ModItems.PAU_BRASIL_HANGING_SIGN.get());
        this.buttonItem(ModBlocks.IPE_AMARELO_BUTTON, ModBlocks.IPE_AMARELO_PLANKS);
        this.fenceItem(ModBlocks.IPE_AMARELO_FENCE, ModBlocks.IPE_AMARELO_PLANKS);
        this.basicItem(ModBlocks.IPE_AMARELO_DOOR.asItem());
        this.basicItem((Item)ModItems.IPE_AMARELO_SIGN.get());
        this.basicItem((Item)ModItems.IPE_AMARELO_HANGING_SIGN.get());
        this.basicItem((Item)ModItems.SMALL_STONE.get());
        this.withExistingParent(ModItems.BUTTERFLY_SPAWN_EGG.getId().getPath(), this.mcLoc("item/template_spawn_egg"));
    }

    private ItemModelBuilder saplingItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("block/" + item.getId().getPath())));
    }

    private void trimmedArmorItem(DeferredItem<Item> itemDeferredItem) {
        String MOD_ID = "distantlandsmc";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("item/" + itemDeferredItem.getId().getPath())));
            });
        }
    }

    private ItemModelBuilder horizontalBlockItem(DeferredBlock<?> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(block.getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("block/" + block.getId().getPath()))));
    }

    public void flowerItem(DeferredBlock<?> block) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("block/" + block.getId().getPath())));
    }

    public void buttonItem(DeferredBlock<?> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void fenceItem(DeferredBlock<?> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void wallItem(DeferredBlock<?> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("block/" + baseBlock.getId().getPath())));
    }

    private ItemModelBuilder handheldItem(DeferredItem<?> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)("item/" + item.getId().getPath())));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

