/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.entity.client.butterfly;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.beastguy.distantlandsmc.entity.client.butterfly.ButterflyModel;
import net.beastguy.distantlandsmc.entity.client.butterfly.ButterflyVariant;
import net.beastguy.distantlandsmc.entity.custom.ButterflyEntity;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ButterflyRenderer
extends GeoEntityRenderer<ButterflyEntity> {
    private static final Map<ButterflyVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(ButterflyVariant.class), map -> {
        map.put(ButterflyVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/entity/butterfly/butterfly_one.png"));
        map.put(ButterflyVariant.TWO, ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/entity/butterfly/butterfly_two.png"));
        map.put(ButterflyVariant.THREE, ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/entity/butterfly/butterfly_three.png"));
        map.put(ButterflyVariant.FOUR, ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/entity/butterfly/butterfly_four.png"));
    });

    public ButterflyRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new ButterflyModel());
        this.shadowRadius = 0.1f;
    }

    public void preRender(PoseStack poseStack, ButterflyEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        poseStack.scale(0.5f, 0.5f, 0.5f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(ButterflyEntity pEntity) {
        return LOCATION_BY_VARIANT.get((Object)pEntity.getVariant());
    }
}

