/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.entity.custom;

import net.beastguy.distantlandsmc.entity.client.butterfly.ButterflyVariant;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ButterflyEntity
extends Animal
implements GeoEntity,
FlyingAnimal {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float flap;
    public float flapSpeed;
    public float oFlap;
    public float oFlapSpeed;
    private float flapping = 1.0f;
    private boolean landing = false;
    private boolean inJar = false;

    public ButterflyEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new ButterflyLandGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.35).add(Attributes.FOLLOW_RANGE, 12.0);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, level);
        nav.setCanFloat(true);
        return nav;
    }

    public void aiStep() {
        super.aiStep();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.onGround() && !this.landing ? 4 : -1) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 motion = this.getDeltaMovement();
        if (this.landing && !this.onGround()) {
            this.setDeltaMovement(motion.x, Math.max(motion.y - 0.05, -0.2), motion.z);
            if (this.onGround()) {
                this.landing = false;
            }
        } else if (!this.onGround() && motion.y < 0.0) {
            this.setDeltaMovement(motion.x, motion.y * 0.6, motion.z);
        }
        this.flap += this.flapping * 2.0f;
    }

    public void travel(@NotNull Vec3 movementInput) {
        if (this.isFlying()) {
            this.moveRelative(0.1f, movementInput);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.91));
        } else {
            super.travel(movementInput);
        }
    }

    public void setInJar(boolean value) {
        this.inJar = value;
    }

    public boolean isInJar() {
        return this.inJar;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (this.isInJar()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    protected void checkFallDamage(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public ButterflyVariant getVariant() {
        return ButterflyVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(ButterflyVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(VARIANT, (Object)pCompound.getInt("Variant"));
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        ButterflyVariant variant = (ButterflyVariant)((Object)Util.getRandom((Object[])ButterflyVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 1, state -> {
            if (this.isFlying() || state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("fly"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class ButterflyLandGoal
    extends WaterAvoidingRandomFlyingGoal {
        private final ButterflyEntity butterfly;

        public ButterflyLandGoal(ButterflyEntity butterfly, double speed) {
            super((PathfinderMob)butterfly, speed);
            this.butterfly = butterfly;
        }

        @Nullable
        protected Vec3 getPosition() {
            BlockPos pos;
            if (!this.butterfly.onGround() && (double)this.butterfly.random.nextFloat() < 0.8 && (pos = this.findLandingBlock()) != null) {
                this.butterfly.landing = true;
                return Vec3.atBottomCenterOf((Vec3i)pos);
            }
            this.butterfly.landing = false;
            return super.getPosition();
        }

        @Nullable
        private BlockPos findLandingBlock() {
            BlockPos origin = this.butterfly.blockPosition();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)origin.offset(-3, -1, -3), (BlockPos)origin.offset(3, 1, 3))) {
                BlockState state = this.butterfly.level().getBlockState(pos);
                if (!state.is(BlockTags.DIRT) && !state.is(BlockTags.LEAVES) && !state.is(Blocks.DANDELION) && !state.is(Blocks.POPPY) || !this.butterfly.level().isEmptyBlock(pos.above())) continue;
                return pos;
            }
            return null;
        }
    }
}

