/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.entity.custom.boat;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.beastguy.distantlandsmc.block.ModBlocks;
import net.beastguy.distantlandsmc.entity.ModEntity;
import net.beastguy.distantlandsmc.item.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.defineId(ModBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModBoatEntity(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ModBoatEntity(Level level, double pX, double pY, double pZ) {
        this(ModEntity.MOD_BOAT.get(), level);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    @NotNull
    public Item getDropItem() {
        return this.getModVariant().getBoatItem();
    }

    public void setVariant(Type pVariant) {
        this.entityData.set(DATA_ID_TYPE, (Object)pVariant.ordinal());
    }

    public Type getModVariant() {
        return Type.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE, (Object)Type.HARU.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putString("Type", this.getModVariant().getSerializedName());
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.contains("Type", 8)) {
            this.setVariant(Type.byName(pCompound.getString("Type")));
        }
    }

    public static enum Type implements StringRepresentable
    {
        HARU((Block)ModBlocks.HARU_PLANKS.get(), "haru", (Supplier<Item>)ModItems.HARU_BOAT, (Supplier<Item>)ModItems.HARU_CHEST_BOAT),
        JACARANDA((Block)ModBlocks.JACARANDA_PLANKS.get(), "jacaranda", (Supplier<Item>)ModItems.JACARANDA_BOAT, (Supplier<Item>)ModItems.JACARANDA_CHEST_BOAT),
        PAU_BRASIL((Block)ModBlocks.PAU_BRASIL_PLANKS.get(), "pau_brasil", (Supplier<Item>)ModItems.PAU_BRASIL_BOAT, (Supplier<Item>)ModItems.PAU_BRASIL_CHEST_BOAT),
        IPE_AMARELO((Block)ModBlocks.IPE_AMARELO_PLANKS.get(), "ipe_amarelo", (Supplier<Item>)ModItems.IPE_AMARELO_BOAT, (Supplier<Item>)ModItems.IPE_AMARELO_CHEST_BOAT);

        private final String name;
        private final Block planks;
        private final Supplier<Item> boatItem;
        private final Supplier<Item> chestBoatItem;
        public static final Codec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private static final Map<String, Type> NAME_MAP;

        private Type(Block planks, String name, Supplier<Item> boatItem, Supplier<Item> chestBoatItem) {
            this.name = name;
            this.planks = planks;
            this.boatItem = boatItem;
            this.chestBoatItem = chestBoatItem;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public Item getBoatItem() {
            return this.boatItem.get();
        }

        public Item getChestBoatItem() {
            return this.chestBoatItem.get();
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Type byName(String pName) {
            return NAME_MAP.getOrDefault(pName, HARU);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            NAME_MAP = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getSerializedName, t -> t));
        }
    }
}

