/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.entity.custom.boat;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.beastguy.distantlandsmc.DistantLandsMod;
import net.beastguy.distantlandsmc.entity.custom.boat.ModBoatEntity;
import net.beastguy.distantlandsmc.entity.custom.boat.ModChestBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;

public class ModBoatRenderer
extends BoatRenderer {
    private final Map<ModBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> Objects.requireNonNull(type, "Enum type cannot be null"), type -> Pair.of((Object)DistantLandsMod.rl(ModBoatRenderer.getTextureLocation(Objects.requireNonNull(type), pChestBoat)), this.createBoatModel(pContext, Objects.requireNonNull(type), pChestBoat))));

    public ModBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(ModBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getSerializedName() + ".png" : "textures/entity/boat/" + pType.getSerializedName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, ModBoatEntity.Type type, boolean chestBoat) {
        ResourceLocation location = DistantLandsMod.rl(type.getSerializedName());
        ModelLayerLocation modellayerlocation = chestBoat ? new ModelLayerLocation(location.withPrefix("chest_boat/"), "main") : new ModelLayerLocation(location.withPrefix("boat/"), "main");
        ModelPart modelpart = context.bakeLayer(modellayerlocation);
        return chestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("boat/" + pType.getSerializedName());
    }

    public static ModelLayerLocation createChestBoatModelName(ModBoatEntity.Type pType) {
        return ModBoatRenderer.createLocation("chest_boat/" + pType.getSerializedName());
    }

    private static ModelLayerLocation createLocation(String pPath) {
        return new ModelLayerLocation(DistantLandsMod.rl(pPath), "main");
    }

    @NotNull
    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@NotNull Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        throw new IllegalArgumentException("Unknown boat type: " + String.valueOf(boat));
    }
}

