/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.entity.goals;

import java.util.EnumSet;
import net.beastguy.distantlandsmc.sound.ModSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class StalkAndLeapGoal
extends Goal {
    private final Mob mob;
    private LivingEntity target;
    private final double leapVelocity;
    private final float maxStalkDistance;
    private final float leapDistance;
    private int stalkTime;
    private boolean attackedThisJump;

    public StalkAndLeapGoal(Mob mob, double leapVelocity, float maxStalkDistance, float leapDistance) {
        this.mob = mob;
        this.leapVelocity = leapVelocity;
        this.maxStalkDistance = maxStalkDistance;
        this.leapDistance = leapDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        if (this.target == null || !this.target.isAlive()) {
            return false;
        }
        double distance = this.mob.distanceToSqr((Entity)this.target);
        return distance <= (double)(this.maxStalkDistance * this.maxStalkDistance);
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.mob.distanceToSqr((Entity)this.target) <= (double)(this.maxStalkDistance * this.maxStalkDistance);
    }

    public void start() {
        this.stalkTime = 0;
        this.attackedThisJump = false;
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        double distance = this.mob.distanceTo((Entity)this.target);
        if (distance > (double)this.leapDistance) {
            ++this.stalkTime;
            if (this.stalkTime % 40 == 0) {
                if (this.mob.getRandom().nextBoolean()) {
                    this.mob.playSound(ModSounds.ONCA_HOSTILE.get(), 1.2f, 1.0f);
                } else {
                    this.mob.playSound(ModSounds.ONCA_HOSTILE2.get(), 1.2f, 1.0f);
                }
            }
        } else if (!this.attackedThisJump) {
            double dx = this.target.getX() - this.mob.getX();
            double dz = this.target.getZ() - this.mob.getZ();
            double dy = this.target.getY() - this.mob.getY();
            double dist = Math.sqrt(dx * dx + dz * dz);
            if (dist > 0.0) {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(dx / dist * 0.4 * this.leapVelocity, 0.4 + dy * 0.2, dz / dist * 0.4 * this.leapVelocity));
            }
            if (this.mob.getRandom().nextBoolean()) {
                this.mob.playSound(ModSounds.ONCA_HOSTILE.get(), 1.5f, 0.9f);
            } else {
                this.mob.playSound(ModSounds.ONCA_HOSTILE2.get(), 1.5f, 1.1f);
            }
            this.mob.doHurtTarget((Entity)this.target);
            this.attackedThisJump = true;
        }
    }
}

