/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.event;

import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.beastguy.distantlandsmc.block.ModBlocks;
import net.beastguy.distantlandsmc.item.ModItems;
import net.beastguy.distantlandsmc.item.custom.HammerItem;
import net.beastguy.distantlandsmc.villager.ModVillagers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.server.command.ConfigCommand;

@EventBusSubscriber(modid="distantlandsmc")
public class ModEvents {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void onHammerUsage(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof HammerItem) {
            HammerItem hammer = (HammerItem)item;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos initialBlockPos = event.getPos();
                if (HARVESTED_BLOCKS.contains(initialBlockPos)) {
                    return;
                }
                for (BlockPos pos : HammerItem.getBlocksToBeDestroyed(1, initialBlockPos, serverPlayer)) {
                    if (pos == initialBlockPos || !hammer.isCorrectToolForDrops(mainHandItem, event.getLevel().getBlockState(pos))) continue;
                    HARVESTED_BLOCKS.add(pos);
                    serverPlayer.gameMode.destroyBlock(pos);
                    HARVESTED_BLOCKS.remove(pos);
                }
            }
        }
    }

    @SubscribeEvent
    public static void livingDamage(LivingDamageEvent.Pre event) {
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
    }

    @SubscribeEvent
    public static void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == ModVillagers.CARPENTER.value()) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 20), new ItemStack((ItemLike)ModItems.CHAINSAW.get(), 1), 12, 3, 0.05f));
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.OAK_LOG, 32), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, 0.05f));
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.BIRCH_LOG, 32), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, 0.05f));
            ((List)trades.get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.SPRUCE_LOG, 32), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 2, 0.05f));
            ((List)trades.get(2)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)Items.CRIMSON_STEM, 2), 12, 3, 0.05f));
            ((List)trades.get(2)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)Items.WARPED_STEM, 2), 12, 3, 0.05f));
            ((List)trades.get(3)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.BAMBOO, 10), 12, 3, 0.05f));
            ((List)trades.get(4)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 18), new ItemStack(ModBlocks.JACARANDA_SAPLING, 20), 16, 2, 0.05f));
            ((List)trades.get(4)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 18), new ItemStack(ModBlocks.IPE_AMARELO_SAPLING, 20), 16, 2, 0.05f));
            ((List)trades.get(5)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 24), new ItemStack(ModBlocks.PEDESTAL, 1), 12, 10, 0.05f));
            ((List)trades.get(5)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 20), new ItemStack(ModBlocks.PAU_BRASIL_SAPLING, 4), 5, 15, 0.05f));
        }
    }

    @SubscribeEvent
    public static void addWanderingTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)ModBlocks.JACARANDA_SAPLING.get(), 1), 1, 10, 0.2f));
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)ModBlocks.IPE_AMARELO_SAPLING.get(), 1), 1, 10, 0.2f));
        rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 15), new ItemStack((ItemLike)ModBlocks.PAU_BRASIL_SAPLING.get(), 8), 1, 20, 0.2f));
    }
}

