/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.item.custom;

import java.util.List;
import net.beastguy.distantlandsmc.component.ModDataComponentTypes;
import net.beastguy.distantlandsmc.entity.ModEntity;
import net.beastguy.distantlandsmc.entity.client.butterfly.ButterflyVariant;
import net.beastguy.distantlandsmc.entity.custom.ButterflyEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ButterflyJarBlockItem
extends BlockItem {
    public ButterflyJarBlockItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1));
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (!player.level().isClientSide && target instanceof ButterflyEntity) {
            ButterflyEntity butterfly = (ButterflyEntity)target;
            if (stack.get((DataComponentType)ModDataComponentTypes.BUTTERFLY_VARIANT.get()) != null) {
                return InteractionResult.PASS;
            }
            ButterflyVariant variant = butterfly.getVariant();
            if (player.isCreative()) {
                ItemStack copy = stack.copy();
                copy.set((DataComponentType)ModDataComponentTypes.BUTTERFLY_VARIANT.get(), (Object)variant);
                player.setItemInHand(hand, copy);
            } else {
                stack.set((DataComponentType)ModDataComponentTypes.BUTTERFLY_VARIANT.get(), (Object)variant);
                butterfly.remove(Entity.RemovalReason.DISCARDED);
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 1.2f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            ItemStack stack = context.getItemInHand();
            ButterflyVariant variant = (ButterflyVariant)((Object)stack.get((DataComponentType)ModDataComponentTypes.BUTTERFLY_VARIANT.get()));
            InteractionResult result = super.place(context);
            if ((result == InteractionResult.SUCCESS || result == InteractionResult.CONSUME) && variant != null) {
                BlockPos pos = context.getClickedPos();
                ButterflyEntity butterfly = (ButterflyEntity)ModEntity.BUTTERFLY.get().create(level);
                if (butterfly != null) {
                    butterfly.setVariant(variant);
                    butterfly.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
                    butterfly.setNoAi(true);
                    butterfly.setInvulnerable(true);
                    butterfly.setPersistenceRequired();
                    butterfly.setInJar(true);
                    level.addFreshEntity((Entity)butterfly);
                    Player player = context.getPlayer();
                    if (player != null) {
                        double dx = player.getX() - butterfly.getX();
                        double dy = player.getY() + (double)player.getEyeHeight() - butterfly.getY();
                        double dz = player.getZ() - butterfly.getZ();
                        float yaw = (float)(Math.atan2(-dx, dz) * 180.0 / Math.PI);
                        float pitch = (float)(-Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))));
                        butterfly.setYRot(yaw);
                        butterfly.setXRot(pitch);
                        butterfly.yBodyRot = yaw;
                        butterfly.yHeadRot = yaw;
                    }
                    stack.remove((DataComponentType)ModDataComponentTypes.BUTTERFLY_VARIANT.get());
                }
            }
            return result;
        }
        return super.place(context);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ButterflyVariant variant = (ButterflyVariant)((Object)stack.get((DataComponentType)ModDataComponentTypes.BUTTERFLY_VARIANT.get()));
        if (variant != null) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.distantlandsmc.butterfly_jar.contains", (Object[])new Object[]{Component.translatable((String)variant.getTranslationKey())}).withStyle(ChatFormatting.YELLOW));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.distantlandsmc.butterfly_jar.empty").withStyle(ChatFormatting.GRAY));
        }
    }
}

