/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.beastguy.distantlandsmc.block.ModBlocks;
import net.beastguy.distantlandsmc.recipe.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CarpenterTableRecipe
extends SingleItemRecipe {
    private final int inputCount;

    public CarpenterTableRecipe(String group, Ingredient ingredient, ItemStack itemStack, int inputCount) {
        super((RecipeType)ModRecipeTypes.CARPENTER_TABLE_TYPE.get(), (RecipeSerializer)ModRecipeTypes.CARPENTER_TABLE_SERIALIZER.get(), group, ingredient, itemStack);
        if (inputCount > 64) {
            throw new IllegalArgumentException("Input count for wood cutting recipe is too high: " + inputCount + ". Ingredient: " + String.valueOf(ingredient) + ", Result: " + String.valueOf(itemStack));
        }
        this.inputCount = inputCount;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean matches(SingleRecipeInput container, @NotNull Level level) {
        ItemStack item = container.getItem(0);
        return this.ingredient.test(item) && item.getCount() >= this.inputCount;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.CARPENTER_TABLE.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CarpenterTableRecipe> {
        private final MapCodec<CarpenterTableRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(arg -> ((CarpenterTableRecipe)arg).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(arg -> ((CarpenterTableRecipe)arg).ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(arg -> ((CarpenterTableRecipe)arg).result), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("ingredient_count", (Object)1).forGetter(arg -> arg.inputCount)).apply((Applicative)instance, CarpenterTableRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, CarpenterTableRecipe> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, arg -> CarpenterTableRecipe.access$200(arg), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, arg -> CarpenterTableRecipe.access$100(arg), (StreamCodec)ItemStack.STREAM_CODEC, arg -> CarpenterTableRecipe.access$000(arg), (StreamCodec)ByteBufCodecs.VAR_INT, arg -> arg.inputCount, CarpenterTableRecipe::new);

        @NotNull
        public MapCodec<CarpenterTableRecipe> codec() {
            return this.codec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CarpenterTableRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

