/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.recipe;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.beastguy.distantlandsmc.payloads.SyncRecipeOrderPayload;
import net.beastguy.distantlandsmc.recipe.CarpenterTableRecipe;
import net.beastguy.distantlandsmc.util.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class RecipeSorter {
    private static final List<Item> ITEM_ORDER = new ArrayList<Item>();
    private static final Set<Item> ALL_ITEMS = new HashSet<Item>();
    private static final Map<RecipeHolder<CarpenterTableRecipe>, Integer> recipeIndices = new HashMap<RecipeHolder<CarpenterTableRecipe>, Integer>();
    public static final List<TagKey<?>> HOLLOW_BUTTON_TAGS = List.of(ModTags.Blocks.HOLLOW_LOGS, ModTags.Blocks.STRIPPED_HOLLOW_LOGS);
    public static final List<TagKey<?>> BLOCKS_BUTTON_TAGS = List.of(ModTags.Blocks.WOOD, ModTags.Blocks.STRIPPED_LOG, ModTags.Blocks.STRIPPED_WOOD, ModTags.Blocks.PLANKS, ModTags.Blocks.STAIRS, ModTags.Blocks.SLAB, ModTags.Blocks.FENCE, ModTags.Blocks.FENCE_GATE, ModTags.Blocks.DOOR, ModTags.Blocks.TRAPDOOR, ModTags.Blocks.PRESSURE_PLATE, ModTags.Blocks.BUTTON, ModTags.Blocks.SIGN);
    public static final List<TagKey<?>> TOOLS_BUTTON_TAGS = List.of(ModTags.Items.STICK, ModTags.Items.WOODEN_SWORD, ModTags.Items.WOODEN_PICKAXE, ModTags.Items.WOODEN_AXE, ModTags.Items.WOODEN_SHOVEL, ModTags.Items.WOODEN_HOE);
    public static final List<TagKey<?>> MISC_BUTTON_TAGS = List.of(ModTags.Blocks.CHISELED_BOOKSHELF, ModTags.Blocks.CHEST, ModTags.Blocks.BARREL, ModTags.Blocks.LADDER, ModTags.Items.BOWL, ModTags.Items.BOAT, ModTags.Items.CHEST_BOAT);
    private static final List<TagKey<?>> ORDERED_TAGS = List.of(ModTags.Blocks.WOOD, ModTags.Blocks.STRIPPED_LOG, ModTags.Blocks.STRIPPED_WOOD, ModTags.Blocks.PLANKS, ModTags.Blocks.STAIRS, ModTags.Blocks.SLAB, ModTags.Blocks.FENCE, ModTags.Blocks.FENCE_GATE, ModTags.Blocks.DOOR, ModTags.Blocks.TRAPDOOR, ModTags.Blocks.PRESSURE_PLATE, ModTags.Blocks.BUTTON, ModTags.Blocks.SIGN, ModTags.Blocks.CHISELED_BOOKSHELF, ModTags.Blocks.CHEST, ModTags.Blocks.BARREL, ModTags.Blocks.LADDER, ModTags.Items.BOWL, ModTags.Items.STICK, ModTags.Items.BOAT, ModTags.Items.CHEST_BOAT, ModTags.Items.WOODEN_SWORD, ModTags.Items.WOODEN_PICKAXE, ModTags.Items.WOODEN_AXE, ModTags.Items.WOODEN_SHOVEL, ModTags.Items.WOODEN_HOE, ModTags.Blocks.HOLLOW_LOGS, ModTags.Blocks.STRIPPED_HOLLOW_LOGS);
    public static final List<TagKey<?>> RESET_BUTTON_TAGS = ORDERED_TAGS;

    public static void accept(List<RecipeHolder<CarpenterTableRecipe>> recipes) {
        ALL_ITEMS.clear();
        recipes.forEach(r -> ALL_ITEMS.add(((CarpenterTableRecipe)r.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem()));
        RecipeSorter.refreshIfNeededNoPlayer();
    }

    public static void refreshIfNeeded(RegistryAccess reg) {
        RecipeSorter.refreshIfNeededWithTags(reg, ORDERED_TAGS);
    }

    public static void refreshIfNeededWithTags(RegistryAccess reg, List<TagKey<?>> tags) {
        if (ALL_ITEMS.isEmpty()) {
            return;
        }
        ITEM_ORDER.clear();
        HashSet<Item> unsortedCopy = new HashSet<Item>(ALL_ITEMS);
        for (TagKey<?> tag : tags) {
            Item item;
            if (tag.registry().equals(BuiltInRegistries.BLOCK.key())) {
                TagKey<?> blockTag = tag;
                for (Holder blockHolder : reg.registryOrThrow(BuiltInRegistries.BLOCK.key()).getTagOrEmpty(blockTag)) {
                    item = ((Block)blockHolder.value()).asItem();
                    if (item == Items.AIR || !unsortedCopy.remove(item)) continue;
                    ITEM_ORDER.add(item);
                }
                continue;
            }
            if (!tag.registry().equals(BuiltInRegistries.ITEM.key())) continue;
            TagKey<?> itemTag = tag;
            for (Holder itemHolder : reg.registryOrThrow(BuiltInRegistries.ITEM.key()).getTagOrEmpty(itemTag)) {
                item = (Item)itemHolder.value();
                if (!unsortedCopy.remove(item)) continue;
                ITEM_ORDER.add(item);
            }
        }
        ITEM_ORDER.addAll(unsortedCopy);
    }

    private static void refreshIfNeededNoPlayer() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            RecipeSorter.refreshIfNeeded((RegistryAccess)server.registryAccess());
        }
    }

    public static void sort(List<RecipeHolder<CarpenterTableRecipe>> recipes, Level level) {
        RecipeSorter.refreshIfNeeded(level.registryAccess());
        RecipeSorter.assignIndices(recipes);
        recipes.sort(Comparator.comparingInt(r -> ITEM_ORDER.indexOf(((CarpenterTableRecipe)r.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem())).thenComparingInt(r -> recipeIndices.getOrDefault(r, Integer.MAX_VALUE)).thenComparing(r -> r.id().toString()));
    }

    public static void assignIndices(List<RecipeHolder<CarpenterTableRecipe>> recipes) {
        recipeIndices.clear();
        for (int i = 0; i < recipes.size(); ++i) {
            recipeIndices.put(recipes.get(i), i);
        }
    }

    public static void sendOrderToClient(@Nullable ServerPlayer player, List<RecipeHolder<CarpenterTableRecipe>> safeRecipes) {
        ArrayList<Object> safeItemOrder;
        if (player != null) {
            RecipeSorter.refreshIfNeeded(player.level().registryAccess());
        } else {
            RecipeSorter.refreshIfNeededNoPlayer();
        }
        if (!safeRecipes.isEmpty()) {
            safeItemOrder = new ArrayList();
            for (RecipeHolder<CarpenterTableRecipe> r : safeRecipes) {
                safeItemOrder.add(((CarpenterTableRecipe)r.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
            }
        } else {
            safeItemOrder = new ArrayList<Item>(ITEM_ORDER);
        }
        IntArrayList list = new IntArrayList();
        safeItemOrder.forEach(arg_0 -> RecipeSorter.lambda$sendOrderToClient$4((IntList)list, arg_0));
        SyncRecipeOrderPayload payload = new SyncRecipeOrderPayload((IntList)list);
        if (player != null) {
            player.connection.send((CustomPacketPayload)payload);
        } else {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerPlayer p : server.getPlayerList().getPlayers()) {
                    p.connection.send((CustomPacketPayload)payload);
                }
            }
        }
    }

    public static void acceptOrder(IntList list) {
        ITEM_ORDER.clear();
        IntListIterator intListIterator = list.iterator();
        while (intListIterator.hasNext()) {
            int id = (Integer)intListIterator.next();
            ITEM_ORDER.add((Item)BuiltInRegistries.ITEM.byId(id));
        }
    }

    public static void sendOrderToClient(@Nullable ServerPlayer player) {
        RecipeSorter.sendOrderToClient(player, Collections.emptyList());
    }

    private static /* synthetic */ void lambda$sendOrderToClient$4(IntList list, Item i) {
        list.add(BuiltInRegistries.ITEM.getId((Object)i));
    }
}

