/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.screen.custom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.beastguy.distantlandsmc.block.ModBlocks;
import net.beastguy.distantlandsmc.recipe.CarpenterTableRecipe;
import net.beastguy.distantlandsmc.recipe.FilterableRecipe;
import net.beastguy.distantlandsmc.recipe.ModRecipeTypes;
import net.beastguy.distantlandsmc.recipe.RecipeSorter;
import net.beastguy.distantlandsmc.screen.ModMenuTypes;
import net.beastguy.distantlandsmc.sound.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CarpenterTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex;
    private final Level level;
    public final Container container;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private final Player player;
    private List<FilterableRecipe> recipes;
    private final List<FilterableRecipe> filteredRecipes = new ArrayList<FilterableRecipe>();
    private ItemStack input;
    private long lastSoundTime;
    private final ResultContainer resultContainer;
    private Runnable slotUpdateListener;
    private FilterableRecipe lastSelectedRecipe = null;
    private String currentFilter = "";
    private List<TagKey<?>> currentTags = new ArrayList();

    public List<TagKey<?>> getCurrentCategoryTags() {
        return this.currentTags;
    }

    public CarpenterTableMenu(int i, Inventory inventory, FriendlyByteBuf ignoredBuf) {
        this(i, inventory, ContainerLevelAccess.NULL);
    }

    public CarpenterTableMenu(int i, Inventory inventory, final ContainerLevelAccess containerLevelAccess) {
        super((MenuType)ModMenuTypes.CARPENTER_TABLE_MENU.get(), i);
        int j;
        this.selectedRecipeIndex = DataSlot.standalone();
        this.recipes = Lists.newArrayList();
        this.input = ItemStack.EMPTY;
        this.slotUpdateListener = () -> {};
        this.container = new SimpleContainer(1){

            public void setChanged() {
                super.setChanged();
                CarpenterTableMenu.this.slotsChanged((Container)this);
                CarpenterTableMenu.this.slotUpdateListener.run();
            }
        };
        this.resultContainer = new ResultContainer();
        this.access = containerLevelAccess;
        this.level = inventory.player.level();
        this.player = inventory.player;
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 21, 33));
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                ItemStack itemStack;
                stack.onCraftedBy(player.level(), player, stack.getCount());
                CarpenterTableMenu.this.resultContainer.awardUsedRecipes(player, List.of(CarpenterTableMenu.this.inputSlot.getItem()));
                if (CarpenterTableMenu.this.selectedRecipeIndex.get() >= 0 && CarpenterTableMenu.this.selectedRecipeIndex.get() < CarpenterTableMenu.this.filteredRecipes.size() && !(itemStack = CarpenterTableMenu.this.inputSlot.remove(((CarpenterTableRecipe)CarpenterTableMenu.this.filteredRecipes.get(CarpenterTableMenu.this.selectedRecipeIndex.get()).recipe().value()).getInputCount())).isEmpty()) {
                    CarpenterTableMenu.this.setupResultSlot();
                }
                containerLevelAccess.execute((level, blockPos) -> {
                    long l = level.getGameTime();
                    if (CarpenterTableMenu.this.lastSoundTime != l) {
                        level.playSound(null, blockPos, ModSounds.CHAINSAW_CUT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        CarpenterTableMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(player, stack);
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<FilterableRecipe> getRecipes() {
        return this.recipes;
    }

    public List<FilterableRecipe> getFilteredRecipes() {
        return this.filteredRecipes;
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public boolean stillValid(@NotNull Player player) {
        return CarpenterTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.CARPENTER_TABLE.get()));
    }

    public boolean clickMenuButton(@NotNull Player player, int id) {
        if ((id = Byte.toUnsignedInt((byte)id)) < this.filteredRecipes.size()) {
            this.selectedRecipeIndex.set(id);
            this.setupResultSlot();
            int actualIndex = this.recipes.indexOf(this.filteredRecipes.get(id));
            if (actualIndex >= 0 && player.level().isClientSide()) {
                Objects.requireNonNull(Minecraft.getInstance().getConnection()).send((Packet)new ServerboundContainerButtonClickPacket(this.containerId, actualIndex));
            }
        }
        return true;
    }

    public void slotsChanged(@NotNull Container container) {
        ItemStack itemStack = this.inputSlot.getItem();
        boolean sameStack = itemStack.is(this.input.getItem());
        int maxItemsThatCanBeConsumed = 5;
        if (!sameStack || itemStack.getCount() < maxItemsThatCanBeConsumed || this.input.getCount() < maxItemsThatCanBeConsumed) {
            this.input = itemStack.copy();
            this.setupRecipeList(container, itemStack);
        }
    }

    private static SingleRecipeInput createRecipeInput(Container container) {
        return new SingleRecipeInput(container.getItem(0));
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        if (!stack.isEmpty()) {
            Player player;
            List matching = this.level.getRecipeManager().getRecipesFor((RecipeType)ModRecipeTypes.CARPENTER_TABLE_TYPE.get(), (RecipeInput)CarpenterTableMenu.createRecipeInput(container), this.level);
            RecipeSorter.accept(matching);
            RecipeSorter.sort(matching, this.level);
            if (!this.level.isClientSide() && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ArrayList<RecipeHolder<CarpenterTableRecipe>> safeMatching = new ArrayList<RecipeHolder<CarpenterTableRecipe>>(matching);
                RecipeSorter.sendOrderToClient(serverPlayer, safeMatching);
            }
            this.recipes = matching.stream().map(FilterableRecipe::of).limit(256L).toList();
            this.applyFilters(this.currentTags, this.currentFilter);
            if (this.lastSelectedRecipe != null) {
                int newInd = this.filteredRecipes.indexOf(this.lastSelectedRecipe);
                this.selectedRecipeIndex.set(newInd);
            } else {
                this.selectedRecipeIndex.set(-1);
            }
        }
        this.lastSelectedRecipe = null;
    }

    public void applyFilters(List<TagKey<?>> tags, String textFilter) {
        this.filteredRecipes.clear();
        this.currentFilter = textFilter != null ? textFilter.toLowerCase(Locale.ROOT) : "";
        this.currentTags = tags != null ? new ArrayList(tags) : new ArrayList();
        for (FilterableRecipe r : this.recipes) {
            boolean matchesText;
            Item result = ((CarpenterTableRecipe)r.recipe().value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getItem();
            boolean matchesTag = this.currentTags.isEmpty();
            for (TagKey<?> tag : this.currentTags) {
                if (tag.registry().equals(BuiltInRegistries.BLOCK.key())) {
                    TagKey<?> blockTag = tag;
                    registry = this.level.registryAccess().registryOrThrow(BuiltInRegistries.BLOCK.key());
                    for (Holder holder : registry.getTagOrEmpty(blockTag)) {
                        if (((Block)holder.value()).asItem() != result) continue;
                        matchesTag = true;
                        break;
                    }
                } else if (tag.registry().equals(BuiltInRegistries.ITEM.key())) {
                    TagKey<?> itemTag = tag;
                    registry = this.level.registryAccess().registryOrThrow(BuiltInRegistries.ITEM.key());
                    for (Holder holder : registry.getTagOrEmpty(itemTag)) {
                        if (holder.value() != result) continue;
                        matchesTag = true;
                        break;
                    }
                }
                if (!matchesTag) continue;
                break;
            }
            boolean bl = matchesText = this.currentFilter.isEmpty() || r.matchFilter(this.currentFilter);
            if (!matchesTag || !matchesText) continue;
            this.filteredRecipes.add(r);
        }
        this.selectedRecipeIndex.set(-1);
        this.setupResultSlot();
    }

    public void setTextFilter(String filterText) {
        this.applyFilters(this.currentTags, filterText);
    }

    public void setCategoryTags(List<TagKey<?>> tags) {
        this.applyFilters(tags, this.currentFilter);
    }

    void setupResultSlot() {
        if (!this.filteredRecipes.isEmpty() && this.selectedRecipeIndex.get() >= 0 && this.selectedRecipeIndex.get() < this.filteredRecipes.size()) {
            FilterableRecipe selected;
            this.lastSelectedRecipe = selected = this.filteredRecipes.get(this.selectedRecipeIndex.get());
            ItemStack itemStack = ((CarpenterTableRecipe)selected.recipe().value()).assemble(CarpenterTableMenu.createRecipeInput(this.container), (HolderLookup.Provider)this.level.registryAccess());
            if (itemStack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(selected.recipe());
                this.resultSlot.set(itemStack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @NotNull
    public MenuType<?> getType() {
        return (MenuType)ModMenuTypes.CARPENTER_TABLE_MENU.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack stack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(stack, slot);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index == 1) {
                itemStack2.getItem().onCraftedBy(itemStack2, player.level(), player);
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack2, itemStack);
            } else if (index == 0 ? !this.moveItemStackTo(itemStack2, 2, 38, false) : (this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.CARPENTER_TABLE_TYPE.get(), (RecipeInput)new SingleRecipeInput(itemStack2), this.level).isPresent() ? !this.moveItemStackTo(itemStack2, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemStack2, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemStack2, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
            this.broadcastChanges();
        }
        return itemStack;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((level, blockPos) -> this.clearContainer(player, this.container));
    }
}

