/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.screen.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.beastguy.distantlandsmc.recipe.CarpenterTableRecipe;
import net.beastguy.distantlandsmc.recipe.FilterableRecipe;
import net.beastguy.distantlandsmc.recipe.RecipeSorter;
import net.beastguy.distantlandsmc.screen.custom.CarpenterTableMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CarpenterTableScreen
extends AbstractContainerScreen<CarpenterTableMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/gui/carpenter_table/carpenter_table_stonecutter.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller_disabled");
    private static final ResourceLocation RECIPE_SELECTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_selected");
    private static final ResourceLocation RECIPE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe_highlighted");
    private static final ResourceLocation RECIPE_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/recipe");
    private static final ResourceLocation HOLLOW_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/gui/carpenter_table/hollow_button.png");
    private static final ResourceLocation BLOCKS_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/gui/carpenter_table/blocks_button.png");
    private static final ResourceLocation TOOLS_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/gui/carpenter_table/tools_button.png");
    private static final ResourceLocation MISC_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/gui/carpenter_table/misc_button.png");
    private static final ResourceLocation RESET_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"textures/gui/carpenter_table/reset_button.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;
    private EditBox searchBox;
    private String lastSearchText = "";
    private final List<FilterableRecipe> filteredRecipes = new ArrayList<FilterableRecipe>();
    private int filteredIndex = -1;
    private static final int CATEGORY_BUTTON_WIDTH = 10;
    private static final int CATEGORY_BUTTON_HEIGHT = 10;
    private final List<CategoryButton> categoryButtons = new ArrayList<CategoryButton>();
    private FilterableRecipe selectedRecipe = null;

    public CarpenterTableScreen(CarpenterTableMenu carpenterTableMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)carpenterTableMenu, inventory, component);
        carpenterTableMenu.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    protected void init() {
        super.init();
        Font font = this.font;
        int searchX = this.leftPos + 95;
        int searchY = this.topPos + 2;
        this.searchBox = new EditBox(font, searchX, searchY, 75, 12, (Component)Component.translatable((String)"gui.recipe_search"));
        this.searchBox.setBordered(true);
        this.searchBox.setMaxLength(50);
        this.searchBox.setResponder(text -> {
            ((CarpenterTableMenu)this.menu).setTextFilter((String)text);
            this.filteredRecipes.clear();
            this.filteredRecipes.addAll(((CarpenterTableMenu)this.menu).getFilteredRecipes());
            this.updateSelectedRecipe();
            if (!text.equals(this.lastSearchText)) {
                this.scrollOffs = 0.0f;
                this.startIndex = 0;
            }
            this.lastSearchText = text;
            this.displayRecipes = ((CarpenterTableMenu)this.menu).hasInputItem();
        });
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        int buttonX = this.leftPos + 135;
        int buttonY = this.topPos + 57;
        int spacing = 12;
        this.categoryButtons.clear();
        this.categoryButtons.add(new CategoryButton(HOLLOW_BUTTON, RecipeSorter.HOLLOW_BUTTON_TAGS, buttonX, buttonY));
        this.categoryButtons.add(new CategoryButton(BLOCKS_BUTTON, RecipeSorter.BLOCKS_BUTTON_TAGS, buttonX + spacing, buttonY));
        this.categoryButtons.add(new CategoryButton(TOOLS_BUTTON, RecipeSorter.TOOLS_BUTTON_TAGS, buttonX, buttonY + spacing));
        this.categoryButtons.add(new CategoryButton(MISC_BUTTON, RecipeSorter.MISC_BUTTON_TAGS, buttonX + spacing, buttonY + spacing));
        int resetX = buttonX + spacing * 2;
        int resetY = buttonY + spacing / 2;
        this.categoryButtons.add(new CategoryButton(RESET_BUTTON, RecipeSorter.RESET_BUTTON_TAGS, resetX, resetY));
    }

    protected void containerTick() {
        super.containerTick();
    }

    private void updateSelectedRecipe() {
        int selectedInd = ((CarpenterTableMenu)this.menu).getSelectedRecipeIndex();
        if (selectedInd > -1 && selectedInd < this.filteredRecipes.size()) {
            this.selectedRecipe = this.filteredRecipes.get(selectedInd);
            this.filteredIndex = selectedInd;
        } else {
            this.selectedRecipe = null;
            this.filteredIndex = -1;
        }
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        this.init(minecraft, width, height);
        this.containerChanged();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.searchBox.isFocused() && this.searchBox.getValue().isEmpty()) {
            int color = -11184811;
            guiGraphics.drawString(this.font, "Search", this.searchBox.getX() + 3, this.searchBox.getY() + 2, color, false);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int barH = this.scrollBarHeight();
        int scrollY = this.minScrollY();
        float barSpan = this.maxScrollY() - scrollY - barH;
        int barPos = (int)(barSpan * this.scrollOffs);
        ResourceLocation scrollSprite = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.blitSprite(scrollSprite, this.minScrollX(), scrollY + barPos, 12, barH);
        for (CategoryButton button : this.categoryButtons) {
            int texWidth = 10;
            int texHeight = 10;
            int fullTexWidth = texWidth;
            int fullTexHeight = texHeight * 2;
            int yOffset = 0;
            int drawX = button.x;
            int drawY = button.y;
            if (button.texture.equals((Object)RESET_BUTTON)) {
                fullTexWidth = 11;
                fullTexHeight = 24;
            } else {
                for (TagKey<?> tag : button.tags) {
                    if (!((CarpenterTableMenu)this.menu).getCurrentCategoryTags().contains(tag)) continue;
                    yOffset = texHeight;
                    break;
                }
            }
            guiGraphics.blit(button.texture, drawX, drawY, 0.0f, (float)yOffset, texWidth, texHeight, fullTexWidth, fullTexHeight);
        }
        if (!this.displayRecipes) {
            return;
        }
        this.forEachButton((index, buttonX, buttonY) -> {
            FilterableRecipe recipe = this.filteredRecipes.get(index);
            ResourceLocation buttonTexture = recipe.equals(this.selectedRecipe) ? RECIPE_SELECTED_SPRITE : (mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + 16 && mouseY < buttonY + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
            guiGraphics.blitSprite(buttonTexture, buttonX, buttonY, 16, 18);
        });
        if (this.minecraft != null && this.minecraft.level != null) {
            this.forEachButton((index, buttonX, buttonY) -> {
                ItemStack item = ((CarpenterTableRecipe)this.filteredRecipes.get(index).recipe().value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess());
                guiGraphics.renderFakeItem(item, buttonX, buttonY + 1);
                guiGraphics.renderItemDecorations(this.font, item, buttonX, buttonY + 1);
            });
        }
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.displayRecipes && this.minecraft != null && this.minecraft.level != null) {
            this.forEachButton((index, buttonX, buttonY) -> {
                if (mouseX >= buttonX && mouseX < buttonX + 16 && mouseY >= buttonY && mouseY < buttonY + 18) {
                    guiGraphics.renderTooltip(this.font, ((CarpenterTableRecipe)this.filteredRecipes.get(index).recipe().value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), mouseX, mouseY);
                }
            });
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int input;
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (this.filteredIndex >= 0 && this.filteredIndex < this.filteredRecipes.size() && (input = ((CarpenterTableRecipe)this.filteredRecipes.get(this.filteredIndex).recipe().value()).getInputCount()) != 1) {
            String multiplier = input + "x";
            int labelX = this.titleLabelX;
            guiGraphics.drawString(this.font, multiplier, labelX, this.titleLabelY + 37, 0x404040, false);
        }
    }

    private int getButtonCount() {
        return this.getRowCount() * this.getButtonsPerRow();
    }

    private int getButtonsPerRow() {
        return 4;
    }

    private int getRowCount() {
        return 3;
    }

    private int minScrollX() {
        return this.leftPos + 119;
    }

    private int maxScrollX() {
        return this.minScrollX() + 12;
    }

    private int minScrollY() {
        return this.topPos + 15;
    }

    private int maxScrollY() {
        return this.topPos + 70;
    }

    private int scrollBarHeight() {
        return 15;
    }

    private void forEachButton(ButtonConsumer buttonConsumer) {
        int buttonBoxX = this.leftPos + 52;
        int buttonBoxY = this.topPos + 13;
        int lastVisibleElementIndex = this.startIndex + this.getButtonCount();
        int buttonsPerRow = this.getButtonsPerRow();
        for (int index = this.startIndex; index < lastVisibleElementIndex && index < this.filteredRecipes.size(); ++index) {
            int visualIndex = index - this.startIndex;
            int buttonX = buttonBoxX + visualIndex % buttonsPerRow * 16;
            int buttonY = buttonBoxY + visualIndex / buttonsPerRow * 18 + 2;
            buttonConsumer.accept(index, buttonX, buttonY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.searchBox.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.searchBox);
            return true;
        }
        if (this.searchBox.isFocused()) {
            this.searchBox.setFocused(false);
            this.setFocused(null);
        }
        if (button == 0) {
            for (CategoryButton catButton : this.categoryButtons) {
                if (!catButton.isHovered(mouseX, mouseY)) continue;
                if (catButton.tags == RecipeSorter.RESET_BUTTON_TAGS) {
                    ((CarpenterTableMenu)this.menu).setCategoryTags(List.of());
                } else {
                    ((CarpenterTableMenu)this.menu).setCategoryTags(catButton.tags);
                }
                this.filteredRecipes.clear();
                this.filteredRecipes.addAll(((CarpenterTableMenu)this.menu).getFilteredRecipes());
                this.updateSelectedRecipe();
                this.startIndex = 0;
                this.scrollOffs = 0.0f;
                return true;
            }
            if (this.displayRecipes && this.minecraft != null && this.minecraft.player != null && this.minecraft.gameMode != null) {
                AtomicReference<Boolean> success = new AtomicReference<Boolean>(false);
                this.forEachButton((index, buttonX, buttonY) -> {
                    if (((Boolean)success.get()).booleanValue()) {
                        return;
                    }
                    if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 16) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 18)) {
                        this.selectedRecipe = this.filteredRecipes.get(index);
                        this.filteredIndex = index;
                        ((CarpenterTableMenu)this.menu).clickMenuButton((Player)this.minecraft.player, index);
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                        success.set(true);
                    }
                });
                if (success.get().booleanValue()) {
                    return true;
                }
            }
        }
        if (mouseX >= (double)this.minScrollX() && mouseX < (double)this.maxScrollX() && mouseY >= (double)this.minScrollY() && mouseY < (double)this.maxScrollY()) {
            this.scrolling = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int min = this.minScrollY();
            int max = this.maxScrollY();
            this.scrollOffs = ((float)mouseY - (float)min - 7.5f) / ((float)(max - min) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * this.getButtonsPerRow();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)scrollY / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * this.getButtonsPerRow();
        }
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.isFocused()) {
            if (keyCode == 256) {
                this.searchBox.setFocused(false);
                this.setFocused(null);
                return true;
            }
            if (this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            int inventoryKey = Minecraft.getInstance().options.keyInventory.getKey().getValue();
            if (keyCode == inventoryKey) {
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.searchBox.isFocused() && this.searchBox.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.filteredRecipes.size() > this.getButtonCount();
    }

    protected int getOffscreenRows() {
        int buttonsPerRow = this.getButtonsPerRow();
        return (this.filteredRecipes.size() + buttonsPerRow - 1) / buttonsPerRow - this.getRowCount();
    }

    private void containerChanged() {
        this.displayRecipes = ((CarpenterTableMenu)this.menu).hasInputItem();
        this.filteredRecipes.clear();
        this.filteredRecipes.addAll(((CarpenterTableMenu)this.menu).getFilteredRecipes());
        if (this.selectedRecipe != null && this.filteredRecipes.contains(this.selectedRecipe)) {
            this.filteredIndex = this.filteredRecipes.indexOf(this.selectedRecipe);
        } else {
            this.selectedRecipe = null;
            this.filteredIndex = -1;
        }
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }

    private record CategoryButton(ResourceLocation texture, List<TagKey<?>> tags, int x, int y) {
        public boolean isHovered(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX < (double)(this.x + 10) && mouseY >= (double)this.y && mouseY < (double)(this.y + 10);
        }
    }

    private static interface ButtonConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

