/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.worldgen;

import java.util.List;
import net.beastguy.distantlandsmc.block.ModBlocks;
import net.beastguy.distantlandsmc.worldgen.ModConfiguredFeatures;
import net.beastguy.distantlandsmc.worldgen.ModOrePlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> HARU_PLACED_KEY = ModPlacedFeatures.registerKey("haru_placed");
    public static final ResourceKey<PlacedFeature> HARU_SMALL_PLACED_KEY = ModPlacedFeatures.registerKey("haru_small_placed");
    public static final ResourceKey<PlacedFeature> JACARANDA_PLACED_KEY = ModPlacedFeatures.registerKey("jacaranda_placed");
    public static final ResourceKey<PlacedFeature> PAU_BRASIL_PLACED_KEY = ModPlacedFeatures.registerKey("pau_brasil_placed");
    public static final ResourceKey<PlacedFeature> IPE_AMARELO_PLACED_KEY = ModPlacedFeatures.registerKey("ipe_amarelo_placed");
    public static final ResourceKey<PlacedFeature> RUBY_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("ruby_ore_placed");
    public static final ResourceKey<PlacedFeature> NEHTER_CURSED_RUBY_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("nether_cursed_ruby_ore_placed");
    public static final ResourceKey<PlacedFeature> END_CURSED_RUBY_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("end_cursed_ruby_ore_placed");
    public static final ResourceKey<PlacedFeature> RUBY_GEODE_PLACED_KEY = ModPlacedFeatures.registerKey("ruby_geode_placed");
    public static final ResourceKey<PlacedFeature> PETUNIA_PLACED_KEY = ModPlacedFeatures.registerKey("petunia_placed");
    public static final ResourceKey<PlacedFeature> PURPLE_GRASS_PLACED_KEY = ModPlacedFeatures.registerKey("purple_grass_placed");
    public static final ResourceKey<PlacedFeature> JACARANDA_GRASS_PLACED_KEY = ModPlacedFeatures.registerKey("jacaranda_grass_placed");
    public static final ResourceKey<PlacedFeature> PAU_BRASIL_GRASS_PLACED_KEY = ModPlacedFeatures.registerKey("pau_brasil_grass_placed");
    public static final ResourceKey<PlacedFeature> IPE_AMARELO_GRASS_PLACED_KEY = ModPlacedFeatures.registerKey("ipe_amarelo_grass_placed");
    public static final ResourceKey<PlacedFeature> STONES_PATH_PLACED_KEY = ModPlacedFeatures.registerKey("stones_path_placed");
    public static final ResourceKey<PlacedFeature> SAND_DISK_PLACED_KEY = ModPlacedFeatures.registerKey("sand_disk_placed");
    public static final ResourceKey<PlacedFeature> GRAVEL_DISK_PLACED_KEY = ModPlacedFeatures.registerKey("gravel_disk_placed");
    public static final ResourceKey<PlacedFeature> CLAY_DISK_PLACED_KEY = ModPlacedFeatures.registerKey("clay_disk_placed");
    public static final ResourceKey<PlacedFeature> MUD_DISK_PLACED_KEY = ModPlacedFeatures.registerKey("mud_disk_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, RUBY_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_RUBY_ORE_KEY), ModOrePlacement.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, NEHTER_CURSED_RUBY_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_CURSED_RUBY_ORE_KEY), List.of(CountPlacement.of((int)1), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)6), (VerticalAnchor)VerticalAnchor.absolute((int)32)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, END_CURSED_RUBY_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.END_CURSED_RUBY_ORE_KEY), ModOrePlacement.commonOrePlacement(5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)20), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        ModPlacedFeatures.register(context, RUBY_GEODE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.RUBY_GEODE_KEY), List.of(RarityFilter.onAverageOnceEvery((int)24), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)6), (VerticalAnchor)VerticalAnchor.absolute((int)30)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, PETUNIA_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.PETUNIA_KEY), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, PURPLE_GRASS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.PURPLE_GRASS_KEY), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, JACARANDA_GRASS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.JACARANDA_GRASS_KEY), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, PAU_BRASIL_GRASS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.PAU_BRASIL_GRASS_KEY), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, IPE_AMARELO_GRASS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.IPE_AMARELO_GRASS_KEY), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, STONES_PATH_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.STONES_PATH_KEY), List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, HARU_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.HARU_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)10, (float)0.1f, (int)1), (Block)((Block)ModBlocks.HARU_SAPLING.get())));
        ModPlacedFeatures.register(context, HARU_SMALL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.HARU_SMALL_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)5, (float)0.05f, (int)1), (Block)((Block)ModBlocks.HARU_SAPLING.get())));
        ModPlacedFeatures.register(context, JACARANDA_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.JACARANDA_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)25, (float)0.1f, (int)1), (Block)((Block)ModBlocks.JACARANDA_SAPLING.get())));
        ModPlacedFeatures.register(context, PAU_BRASIL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.PAU_BRASIL_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)15, (float)0.1f, (int)1), (Block)((Block)ModBlocks.PAU_BRASIL_SAPLING.get())));
        ModPlacedFeatures.register(context, IPE_AMARELO_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.IPE_AMARELO_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)5, (float)0.1f, (int)1), (Block)((Block)ModBlocks.PAU_BRASIL_SAPLING.get())));
        ModPlacedFeatures.register(context, SAND_DISK_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.SAND_DISK_KEY), List.of(RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, GRAVEL_DISK_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.GRAVEL_DISK_KEY), List.of(RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, CLAY_DISK_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.CLAY_DISK_KEY), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesFluids((Fluid[])new Fluid[]{Fluids.WATER})), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, MUD_DISK_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.MUD_DISK_KEY), List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

