/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.worldgen.biome;

import net.beastguy.distantlandsmc.worldgen.biome.ModEndBiomes;
import net.beastguy.distantlandsmc.worldgen.biome.ModOverworldBiomes;
import net.beastguy.distantlandsmc.worldgen.biome.region.NetherRegion;
import net.beastguy.distantlandsmc.worldgen.biome.region.OverworldRegion;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import terrablender.api.EndBiomeRegistry;
import terrablender.api.Region;
import terrablender.api.Regions;

public class ModBiomes {
    public static final ResourceKey<Biome> END_ROT = ModBiomes.registerBiomeKey("end_rot");
    public static final ResourceKey<Biome> LAVENDER_GROVE = ModBiomes.registerBiomeKey("lavender_grove");
    public static final ResourceKey<Biome> BLOOMING_JACARANDA_GROVE = ModBiomes.registerBiomeKey("blooming_jacaranda_grove");
    public static final ResourceKey<Biome> PAU_BRAZIL_FOREST = ModBiomes.registerBiomeKey("pau_brazil_forest");
    public static final ResourceKey<Biome> YELLOW_IPE_GROVE = ModBiomes.registerBiomeKey("yellow_ipe_grove");

    public static void registerBiomes() {
        Regions.register((Region)new OverworldRegion(ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"distantlandsmc_overworld"), 20));
        Regions.register((Region)new NetherRegion(ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)"distantlandsmc_nether"), 20));
        EndBiomeRegistry.registerHighlandsBiome(END_ROT, (int)20);
    }

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter carver = context.lookup(Registries.CONFIGURED_CARVER);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        ModBiomes.register(context, END_ROT, ModEndBiomes.endRot((HolderGetter<PlacedFeature>)placedFeatures, carver));
        ModBiomes.register(context, LAVENDER_GROVE, ModOverworldBiomes.purplePlains((HolderGetter<PlacedFeature>)placedFeatures, carver));
        ModBiomes.register(context, BLOOMING_JACARANDA_GROVE, ModOverworldBiomes.bloomingJacarandaGrove((HolderGetter<PlacedFeature>)placedFeatures, carver));
        ModBiomes.register(context, PAU_BRAZIL_FOREST, ModOverworldBiomes.pauBrasilForest((HolderGetter<PlacedFeature>)placedFeatures, carver));
        ModBiomes.register(context, YELLOW_IPE_GROVE, ModOverworldBiomes.yellowIpeForest((HolderGetter<PlacedFeature>)placedFeatures, carver));
    }

    private static void register(BootstrapContext<Biome> context, ResourceKey<Biome> key, Biome biome) {
        context.register(key, (Object)biome);
    }

    private static ResourceKey<Biome> registerBiomeKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"distantlandsmc", (String)name));
    }
}

