/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.worldgen.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.placement.EndPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModEndBiomes {
    private static void addFeature(BiomeGenerationSettings.Builder builder, GenerationStep.Decoration step, ResourceKey<PlacedFeature> feature) {
        builder.addFeature(step, feature);
    }

    public static Biome endRot(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        ModEndBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_DECORATION, (ResourceKey<PlacedFeature>)EndPlacements.END_SPIKE);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(4.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(12431667).waterFogColor(12431667).fogColor(12431667).skyColor(ModEndBiomes.calculateSkyColor(2.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.END_ROD, 0.00725f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    protected static int calculateSkyColor(float temperature) {
        float $$1 = temperature / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }
}

