/*
 * Decompiled with CFR 0.152.
 */
package net.beastguy.distantlandsmc.worldgen.biome;

import net.beastguy.distantlandsmc.worldgen.ModPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModOverworldBiomes {
    private static void addFeature(BiomeGenerationSettings.Builder builder, GenerationStep.Decoration step, ResourceKey<PlacedFeature> feature) {
        builder.addFeature(step, feature);
    }

    public static Biome purplePlains(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        BiomeDefaultFeatures.plainsSpawns((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.farmAnimals((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PURPLE_GRASS_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.6f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(10639556).waterFogColor(10639556).fogColor(14205183).skyColor(13148927).grassColorOverride(14268159).foliageColorOverride(10255343).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.CHERRY_LEAVES, 0.003f)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_MEADOW)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome bloomingJacarandaGrove(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 12, 2, 6));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PIG, 10, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 10, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.BEE, 8, 2, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.COW, 8, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 5, 1, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 4, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_SUGAR_CANE);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SIMPLE);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_RIVER);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.JACARANDA_GRASS_PLACED_KEY);
        BiomeSpecialEffects.Builder effects = new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(11589887).skyColor(8438271).grassColorOverride(2312540).foliageColorOverride(0x7FAFFF).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.005f)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST));
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.7f).specialEffects(effects.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome pauBrasilForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 10, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PIG, 8, 2, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 10, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.COW, 8, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 4, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_SUGAR_CANE);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SIMPLE);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_RIVER);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PAU_BRASIL_GRASS_PLACED_KEY);
        BiomeSpecialEffects.Builder effects = new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(5349869).grassColorOverride(7244605).foliageColorOverride(16744272).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.005f)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_JUNGLE));
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(effects.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome yellowIpeForest(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 10, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.PIG, 8, 2, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.CHICKEN, 10, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.COW, 8, 2, 5));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.FOX, 4, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 6, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomeBuilder);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_SUGAR_CANE);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_SIMPLE);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)AquaticPlacements.SEAGRASS_RIVER);
        ModOverworldBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.IPE_AMARELO_GRASS_PLACED_KEY);
        BiomeSpecialEffects.Builder effects = new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(0xFFF5CC).skyColor(6923734).grassColorOverride(16773795).foliageColorOverride(16766720).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.004f)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.MUSIC_BIOME_FOREST));
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.6f).specialEffects(effects.build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    protected static int calculateSkyColor(float temperature) {
        float $$1 = temperature / 3.0f;
        $$1 = Mth.clamp((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }
}

