/*
 * Decompiled with CFR 0.152.
 */
package com.progamer91.sleepvote;

import com.progamer91.sleepvote.SleepVote;
import java.util.HashMap;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SleepListener
implements Listener {
    private final SleepVote plugin;
    private final HashMap<World, BukkitTask> sleepTasks = new HashMap();

    public SleepListener(SleepVote plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.checkSleepStatus(event.getPlayer().getWorld()));
    }

    @EventHandler
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.checkSleepStatus(event.getPlayer().getWorld()));
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.plugin.getIgnoringPlayers().remove(event.getPlayer().getUniqueId());
        this.checkSleepStatus(event.getFrom());
        this.checkSleepStatus(event.getPlayer().getWorld());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getIgnoringPlayers().remove(event.getPlayer().getUniqueId());
        this.checkSleepStatus(event.getPlayer().getWorld());
    }

    private void checkSleepStatus(World world) {
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        long sleepingPlayers = world.getPlayers().stream().filter(LivingEntity::isSleeping).count();
        long totalPlayers = world.getPlayers().stream().filter(p -> !p.getGameMode().equals((Object)GameMode.SPECTATOR) && !this.plugin.getIgnoringPlayers().contains(p.getUniqueId())).count();
        int percentageNeeded = this.plugin.getConfig().getInt("percentage-needed");
        if (totalPlayers == 0L) {
            return;
        }
        long requiredPlayers = (long)Math.ceil((double)totalPlayers * ((double)percentageNeeded / 100.0));
        if (sleepingPlayers >= requiredPlayers) {
            if (!this.sleepTasks.containsKey(world)) {
                String sleepingMessage = this.plugin.getConfig().getString("messages.player-wants-sleep");
                if (sleepingMessage != null) {
                    world.getPlayers().forEach(p -> p.sendMessage(MiniMessage.miniMessage().deserialize(sleepingMessage, new TagResolver[]{Placeholder.unparsed((String)"player", (String)p.getName()), Placeholder.unparsed((String)"sleeping", (String)String.valueOf(sleepingPlayers)), Placeholder.unparsed((String)"required", (String)String.valueOf(requiredPlayers))})));
                }
                BukkitTask task = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    world.setTime(0L);
                    world.setStorm(false);
                    world.setThundering(false);
                    this.plugin.getIgnoringPlayers().clear();
                    String nightSkippedMessage = this.plugin.getConfig().getString("messages.night-skipped");
                    if (nightSkippedMessage != null) {
                        world.getPlayers().forEach(p -> p.sendMessage(MiniMessage.miniMessage().deserialize((Object)nightSkippedMessage)));
                    }
                    this.sleepTasks.remove(world);
                }, (long)this.plugin.getConfig().getInt("sleep-delay-seconds", 4) * 20L);
                this.sleepTasks.put(world, task);
            }
        } else if (this.sleepTasks.containsKey(world)) {
            this.sleepTasks.get(world).cancel();
            this.sleepTasks.remove(world);
            String leftBedMessage = this.plugin.getConfig().getString("messages.player-left-bed");
            if (leftBedMessage != null) {
                world.getPlayers().forEach(p -> p.sendMessage(MiniMessage.miniMessage().deserialize(leftBedMessage, new TagResolver[]{Placeholder.unparsed((String)"player", (String)p.getName()), Placeholder.unparsed((String)"sleeping", (String)String.valueOf(sleepingPlayers)), Placeholder.unparsed((String)"required", (String)String.valueOf(requiredPlayers))})));
            }
        }
    }
}

