/*
 * Decompiled with CFR 0.152.
 */
package com.progamer91.sleepvote;

import com.progamer91.sleepvote.SleepVote;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SleepVoteCommand
implements CommandExecutor,
TabCompleter {
    private final SleepVote plugin;

    public SleepVoteCommand(SleepVote plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)this.plugin.getConfig().getString("messages.invalid-command")));
            return true;
        }
        if (args[0].equalsIgnoreCase("ignore")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("This command can only be run by a player.");
                return true;
            }
            Player player = (Player)sender;
            if (this.plugin.getIgnoringPlayers().contains(player.getUniqueId())) {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)this.plugin.getConfig().getString("messages.already-ignoring")));
            } else {
                this.plugin.getIgnoringPlayers().add(player.getUniqueId());
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)this.plugin.getConfig().getString("messages.sleep-ignored")));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("sleepvote.reload")) {
                sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)this.plugin.getConfig().getString("messages.no-permission")));
                return true;
            }
            this.plugin.reloadConfig();
            sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)this.plugin.getConfig().getString("messages.reload-success")));
            return true;
        }
        sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)this.plugin.getConfig().getString("messages.invalid-command")));
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("ignore");
            if (sender.hasPermission("sleepvote.reload")) {
                completions.add("reload");
            }
            return completions;
        }
        return null;
    }
}

