/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.springframework.aot.AotDetector;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.context.ApplicationContext;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class StartupInfoLogger {
    private final Class<?> sourceClass;

    StartupInfoLogger(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    void logStarting(Log applicationLog) {
        Assert.notNull((Object)applicationLog, "Log must not be null");
        applicationLog.info(LogMessage.of(this::getStartingMessage));
        applicationLog.debug(LogMessage.of(this::getRunningMessage));
    }

    void logStarted(Log applicationLog, SpringApplication.Startup startup) {
        if (applicationLog.isInfoEnabled()) {
            applicationLog.info(this.getStartedMessage(startup));
        }
    }

    private CharSequence getStartingMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Starting");
        this.appendAotMode(message);
        this.appendApplicationName(message);
        this.appendVersion(message, this.sourceClass);
        this.appendJavaVersion(message);
        this.appendPid(message);
        this.appendContext(message);
        return message;
    }

    private CharSequence getRunningMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Running with Spring Boot");
        this.appendVersion(message, this.getClass());
        message.append(", Spring");
        this.appendVersion(message, ApplicationContext.class);
        return message;
    }

    private CharSequence getStartedMessage(SpringApplication.Startup startup) {
        StringBuilder message = new StringBuilder();
        message.append(startup.action());
        this.appendApplicationName(message);
        message.append(" in ");
        message.append((double)startup.timeTakenToStarted().toMillis() / 1000.0);
        message.append(" seconds");
        Long uptimeMs = startup.processUptime();
        if (uptimeMs != null) {
            double uptime = (double)uptimeMs.longValue() / 1000.0;
            message.append(" (process running for ").append(uptime).append(")");
        }
        return message;
    }

    private void appendAotMode(StringBuilder message) {
        this.append(message, "", () -> AotDetector.useGeneratedArtifacts() ? "AOT-processed" : null);
    }

    private void appendApplicationName(StringBuilder message) {
        this.append(message, "", () -> this.sourceClass != null ? ClassUtils.getShortName(this.sourceClass) : "application");
    }

    private void appendVersion(StringBuilder message, Class<?> source) {
        this.append(message, "v", () -> source.getPackage().getImplementationVersion());
    }

    private void appendPid(StringBuilder message) {
        this.append(message, "with PID ", ApplicationPid::new);
    }

    private void appendContext(StringBuilder message) {
        StringBuilder context = new StringBuilder();
        ApplicationHome home = new ApplicationHome(this.sourceClass);
        if (home.getSource() != null) {
            context.append(home.getSource().getAbsolutePath());
        }
        this.append(context, "started by ", () -> System.getProperty("user.name"));
        this.append(context, "in ", () -> System.getProperty("user.dir"));
        if (context.length() > 0) {
            message.append(" (");
            message.append((CharSequence)context);
            message.append(")");
        }
    }

    private void appendJavaVersion(StringBuilder message) {
        this.append(message, "using Java ", () -> System.getProperty("java.version"));
    }

    private void append(StringBuilder message, String prefix, Callable<Object> call) {
        this.append(message, prefix, call, "");
    }

    private void append(StringBuilder message, String prefix, Callable<Object> call, String defaultValue) {
        String value;
        Object result = this.callIfPossible(call);
        String string = value = result != null ? result.toString() : null;
        if (!StringUtils.hasLength(value)) {
            value = defaultValue;
        }
        if (StringUtils.hasLength(value)) {
            message.append(message.length() > 0 ? " " : "");
            message.append(prefix);
            message.append(value);
        }
    }

    private Object callIfPossible(Callable<Object> call) {
        try {
            return call.call();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

