/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.SQLDialect;
import org.jooq.tools.jdbc.JDBCUtils;

final class SqlDialectLookup {
    private static final Log logger = LogFactory.getLog(SqlDialectLookup.class);

    private SqlDialectLookup() {
    }

    static SQLDialect getDialect(DataSource dataSource) {
        try {
            Connection connection = dataSource != null ? dataSource.getConnection() : null;
            return JDBCUtils.dialect((Connection)connection);
        }
        catch (SQLException ex) {
            logger.warn("Unable to determine dialect from datasource", ex);
            return SQLDialect.DEFAULT;
        }
    }
}

