/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Path;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

record BundleContentProperty(String name, String value) {
    boolean isPemContent() {
        return PemContent.isPresentInText(this.value);
    }

    boolean hasValue() {
        return StringUtils.hasText(this.value);
    }

    Path toWatchPath() {
        return this.toPath();
    }

    private Path toPath() {
        try {
            URL url = this.toUrl();
            Assert.state(this.isFileUrl(url), () -> "Value '%s' is not a file URL".formatted(url));
            return Path.of(url.toURI()).toAbsolutePath();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to convert value of property '%s' to a path".formatted(this.name), ex);
        }
    }

    private URL toUrl() throws FileNotFoundException {
        Assert.state(!this.isPemContent(), "Value contains PEM content");
        return ResourceUtils.getURL(this.value);
    }

    private boolean isFileUrl(URL url) {
        return "file".equalsIgnoreCase(url.getProtocol());
    }
}

