/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import org.springframework.boot.logging.logback.SpringProfileModel;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.util.StringUtils;

class SpringProfileModelHandler
extends ModelHandlerBase {
    private final Environment environment;

    SpringProfileModelHandler(Context context, Environment environment2) {
        super(context);
        this.environment = environment2;
    }

    @Override
    public void handle(ModelInterpretationContext intercon, Model model) throws ModelHandlerException {
        SpringProfileModel profileModel = (SpringProfileModel)model;
        if (!this.acceptsProfiles(intercon, profileModel)) {
            model.deepMarkAsSkipped();
        }
    }

    private boolean acceptsProfiles(ModelInterpretationContext ic, SpringProfileModel model) {
        if (this.environment == null) {
            return false;
        }
        String[] profileNames = StringUtils.trimArrayElements(StringUtils.commaDelimitedListToStringArray(model.getName()));
        if (profileNames.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < profileNames.length; ++i2) {
            try {
                profileNames[i2] = OptionHelper.substVars(profileNames[i2], ic, this.context);
                continue;
            }
            catch (ScanException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.environment.acceptsProfiles(Profiles.of(profileNames));
    }
}

