/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.Executor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdkClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final HttpClient httpClient;
    private final Executor executor;
    @Nullable
    private Duration readTimeout;

    public JdkClientHttpRequestFactory() {
        this(HttpClient.newHttpClient());
    }

    public JdkClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        this.httpClient = httpClient;
        this.executor = httpClient.executor().orElseGet(SimpleAsyncTaskExecutor::new);
    }

    public JdkClientHttpRequestFactory(HttpClient httpClient, Executor executor) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        Assert.notNull((Object)executor, "Executor must not be null");
        this.httpClient = httpClient;
        this.executor = executor;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Duration.ofMillis(readTimeout);
    }

    public void setReadTimeout(Duration readTimeout) {
        Assert.notNull((Object)readTimeout, "ReadTimeout must not be null");
        this.readTimeout = readTimeout;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new JdkClientHttpRequest(this.httpClient, uri, httpMethod, this.executor, this.readTimeout);
    }
}

