/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import org.springframework.scheduling.support.ScheduledTaskObservationContext;
import org.springframework.scheduling.support.ScheduledTaskObservationConvention;
import org.springframework.scheduling.support.ScheduledTaskObservationDocumentation;
import org.springframework.util.StringUtils;

public class DefaultScheduledTaskObservationConvention
implements ScheduledTaskObservationConvention {
    private static final String DEFAULT_NAME = "tasks.scheduled.execution";
    private static final KeyValue EXCEPTION_NONE = KeyValue.of(ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, "none");
    private static final KeyValue OUTCOME_SUCCESS = KeyValue.of(ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.OUTCOME, "SUCCESS");
    private static final KeyValue OUTCOME_ERROR = KeyValue.of(ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.OUTCOME, "ERROR");
    private static final KeyValue OUTCOME_UNKNOWN = KeyValue.of(ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.OUTCOME, "UNKNOWN");

    @Override
    public String getName() {
        return DEFAULT_NAME;
    }

    @Override
    public String getContextualName(ScheduledTaskObservationContext context) {
        return "task " + StringUtils.uncapitalize(context.getTargetClass().getSimpleName()) + "." + context.getMethod().getName();
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ScheduledTaskObservationContext context) {
        return KeyValues.of(this.codeFunction(context), this.codeNamespace(context), this.exception(context), this.outcome(context));
    }

    protected KeyValue codeFunction(ScheduledTaskObservationContext context) {
        return KeyValue.of(ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.CODE_FUNCTION, context.getMethod().getName());
    }

    protected KeyValue codeNamespace(ScheduledTaskObservationContext context) {
        return KeyValue.of(ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.CODE_NAMESPACE, context.getTargetClass().getCanonicalName());
    }

    protected KeyValue exception(ScheduledTaskObservationContext context) {
        if (context.getError() != null) {
            return KeyValue.of(ScheduledTaskObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, context.getError().getClass().getSimpleName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue outcome(ScheduledTaskObservationContext context) {
        if (context.getError() != null) {
            return OUTCOME_ERROR;
        }
        if (!context.isComplete()) {
            return OUTCOME_UNKNOWN;
        }
        return OUTCOME_SUCCESS;
    }
}

