/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.util.Collection;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ParameterValidationResult {
    private final MethodParameter methodParameter;
    @Nullable
    private final Object argument;
    private final List<MessageSourceResolvable> resolvableErrors;

    public ParameterValidationResult(MethodParameter param, @Nullable Object arg, Collection<? extends MessageSourceResolvable> errors) {
        Assert.notNull((Object)param, "MethodParameter is required");
        Assert.notEmpty(errors, "`resolvableErrors` must not be empty");
        this.methodParameter = param;
        this.argument = arg;
        this.resolvableErrors = List.copyOf(errors);
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    @Nullable
    public Object getArgument() {
        return this.argument;
    }

    public List<MessageSourceResolvable> getResolvableErrors() {
        return this.resolvableErrors;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        ParameterValidationResult otherResult = (ParameterValidationResult)other;
        return this.getMethodParameter().equals(otherResult.getMethodParameter()) && ObjectUtils.nullSafeEquals(this.getArgument(), otherResult.getArgument());
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 29 * hashCode + this.getMethodParameter().hashCode();
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode(this.getArgument());
        return hashCode;
    }

    public String toString() {
        return "Validation results for method parameter '" + this.methodParameter + "': argument [" + ObjectUtils.nullSafeConciseToString(this.argument) + "]; " + this.getResolvableErrors();
    }
}

