/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.MethodValidationAdapter;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.MethodValidator;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.method.annotation.ModelFactory;

public final class HandlerMethodValidator
implements MethodValidator {
    private static final MethodValidationAdapter.ObjectNameResolver objectNameResolver = new WebObjectNameResolver();
    private final MethodValidationAdapter validationAdapter;
    private final Predicate<MethodParameter> modelAttribitePredicate;
    private final Predicate<MethodParameter> requestParamPredicate;

    private HandlerMethodValidator(MethodValidationAdapter validationAdapter, Predicate<MethodParameter> modelAttribitePredicate, Predicate<MethodParameter> requestParamPredicate) {
        this.validationAdapter = validationAdapter;
        this.modelAttribitePredicate = modelAttribitePredicate;
        this.requestParamPredicate = requestParamPredicate;
    }

    @Override
    public Class<?>[] determineValidationGroups(Object target, Method method) {
        return this.validationAdapter.determineValidationGroups(target, method);
    }

    @Override
    public void applyArgumentValidation(Object target, Method method, @Nullable MethodParameter[] parameters, Object[] arguments, Class<?>[] groups) {
        MethodValidationResult result = this.validateArguments(target, method, parameters, arguments, groups);
        if (!result.hasErrors()) {
            return;
        }
        if (!result.getBeanResults().isEmpty()) {
            int bindingResultCount = 0;
            block0: for (ParameterErrors errors : result.getBeanResults()) {
                for (Object arg : arguments) {
                    BindingResult bindingResult;
                    if (!(arg instanceof BindingResult) || !(bindingResult = (BindingResult)arg).getObjectName().equals(errors.getObjectName())) continue;
                    bindingResult.addAllErrors(errors);
                    ++bindingResultCount;
                    continue block0;
                }
            }
            if (result.getAllValidationResults().size() == bindingResultCount) {
                return;
            }
        }
        throw new HandlerMethodValidationException(result, this.modelAttribitePredicate, this.requestParamPredicate);
    }

    @Override
    public MethodValidationResult validateArguments(Object target, Method method, @Nullable MethodParameter[] parameters, Object[] arguments, Class<?>[] groups) {
        return this.validationAdapter.validateArguments(target, method, parameters, arguments, groups);
    }

    @Override
    public void applyReturnValueValidation(Object target, Method method, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups) {
        MethodValidationResult result = this.validateReturnValue(target, method, returnType, returnValue, groups);
        if (result.hasErrors()) {
            throw new HandlerMethodValidationException(result);
        }
    }

    @Override
    public MethodValidationResult validateReturnValue(Object target, Method method, @Nullable MethodParameter returnType, @Nullable Object returnValue, Class<?>[] groups) {
        return this.validationAdapter.validateReturnValue(target, method, returnType, returnValue, groups);
    }

    @Nullable
    public static MethodValidator from(@Nullable WebBindingInitializer initializer, @Nullable ParameterNameDiscoverer paramNameDiscoverer, Predicate<MethodParameter> modelAttribitePredicate, Predicate<MethodParameter> requestParamPredicate) {
        ConfigurableWebBindingInitializer configurableInitializer;
        jakarta.validation.Validator validator;
        if (initializer instanceof ConfigurableWebBindingInitializer && (validator = HandlerMethodValidator.getValidator(configurableInitializer = (ConfigurableWebBindingInitializer)initializer)) != null) {
            MessageCodesResolver codesResolver;
            MethodValidationAdapter adapter = new MethodValidationAdapter(validator);
            adapter.setObjectNameResolver(objectNameResolver);
            if (paramNameDiscoverer != null) {
                adapter.setParameterNameDiscoverer(paramNameDiscoverer);
            }
            if ((codesResolver = configurableInitializer.getMessageCodesResolver()) != null) {
                adapter.setMessageCodesResolver(codesResolver);
            }
            return new HandlerMethodValidator(adapter, modelAttribitePredicate, requestParamPredicate);
        }
        return null;
    }

    @Nullable
    private static jakarta.validation.Validator getValidator(ConfigurableWebBindingInitializer initializer) {
        Validator validator = initializer.getValidator();
        if (validator instanceof jakarta.validation.Validator) {
            jakarta.validation.Validator validator2 = (jakarta.validation.Validator)validator;
            return validator2;
        }
        validator = initializer.getValidator();
        if (validator instanceof SmartValidator) {
            SmartValidator smartValidator = (SmartValidator)validator;
            return smartValidator.unwrap(jakarta.validation.Validator.class);
        }
        return null;
    }

    private static class WebObjectNameResolver
    implements MethodValidationAdapter.ObjectNameResolver {
        private WebObjectNameResolver() {
        }

        @Override
        public String resolveName(MethodParameter param, @Nullable Object value) {
            if (param.hasParameterAnnotation(RequestBody.class) || param.hasParameterAnnotation(RequestPart.class)) {
                return Conventions.getVariableNameForParameter(param);
            }
            return param.getParameterIndex() != -1 ? ModelFactory.getNameForParameter(param) : ModelFactory.getNameForReturnValue(value, param);
        }
    }
}

