/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.handler;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

public class ResponseStatusExceptionHandler
implements WebExceptionHandler {
    private static final Log logger = LogFactory.getLog(ResponseStatusExceptionHandler.class);
    @Nullable
    private Log warnLogger;

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog(loggerName);
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2, Throwable ex) {
        if (!this.updateResponse(exchange2.getResponse(), ex)) {
            return Mono.error((Throwable)ex);
        }
        String logPrefix = exchange2.getLogPrefix();
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn(logPrefix + this.formatError(ex, exchange2.getRequest()));
        } else if (logger.isDebugEnabled()) {
            logger.debug(logPrefix + this.formatError(ex, exchange2.getRequest()));
        }
        return exchange2.getResponse().setComplete();
    }

    private String formatError(Throwable ex, ServerHttpRequest request) {
        String className = ex.getClass().getSimpleName();
        String message = LogFormatUtils.formatValue(ex.getMessage(), -1, true);
        String path = request.getURI().getRawPath();
        return "Resolved [" + className + ": " + message + "] for HTTP " + request.getMethod() + " " + path;
    }

    private boolean updateResponse(ServerHttpResponse response, Throwable ex) {
        int code;
        boolean result = false;
        HttpStatusCode statusCode = this.determineStatus(ex);
        int n = code = statusCode != null ? statusCode.value() : this.determineRawStatusCode(ex);
        if (code != -1) {
            if (response.setStatusCode(statusCode)) {
                if (ex instanceof ResponseStatusException) {
                    ResponseStatusException responseStatusException = (ResponseStatusException)ex;
                    responseStatusException.getHeaders().forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(name, values) -> values.forEach(value -> response.getHeaders().add((String)name, (String)value))));
                }
                result = true;
            }
        } else {
            Throwable cause = ex.getCause();
            if (cause != null) {
                result = this.updateResponse(response, cause);
            }
        }
        return result;
    }

    @Nullable
    protected HttpStatusCode determineStatus(Throwable ex) {
        if (ex instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)ex;
            return responseStatusException.getStatusCode();
        }
        return null;
    }

    @Deprecated(since="6.0")
    protected int determineRawStatusCode(Throwable ex) {
        if (ex instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)ex;
            return responseStatusException.getStatusCode().value();
        }
        return -1;
    }
}

