/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpServiceMethod {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent("reactor.core.publisher.Mono", HttpServiceMethod.class.getClassLoader());
    private final Method method;
    private final MethodParameter[] parameters;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    private final HttpRequestValuesInitializer requestValuesInitializer;
    private final ResponseFunction responseFunction;

    HttpServiceMethod(Method method, Class<?> containingClass, List<HttpServiceArgumentResolver> argumentResolvers, HttpExchangeAdapter adapter, @Nullable StringValueResolver embeddedValueResolver) {
        this.method = method;
        this.parameters = HttpServiceMethod.initMethodParameters(method);
        this.argumentResolvers = argumentResolvers;
        boolean isReactorAdapter = REACTOR_PRESENT && adapter instanceof ReactorHttpExchangeAdapter;
        this.requestValuesInitializer = HttpRequestValuesInitializer.create(method, containingClass, embeddedValueResolver, isReactorAdapter ? ReactiveHttpRequestValues::builder : HttpRequestValues::builder);
        this.responseFunction = isReactorAdapter ? ReactorExchangeResponseFunction.create((ReactorHttpExchangeAdapter)adapter, method) : ExchangeResponseFunction.create(adapter, method);
    }

    private static MethodParameter[] initMethodParameters(Method method) {
        int count = method.getParameterCount();
        if (count == 0) {
            return new MethodParameter[0];
        }
        if (KotlinDetector.isSuspendingFunction(method)) {
            --count;
        }
        DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i2 = 0; i2 < count; ++i2) {
            parameters[i2] = new SynthesizingMethodParameter(method, i2);
            parameters[i2].initParameterNameDiscovery(nameDiscoverer);
        }
        return parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    @Nullable
    public Object invoke(Object[] arguments) {
        HttpRequestValues.Builder requestValues = this.requestValuesInitializer.initializeRequestValuesBuilder();
        this.applyArguments(requestValues, arguments);
        return this.responseFunction.execute(requestValues.build());
    }

    private void applyArguments(HttpRequestValues.Builder requestValues, Object[] arguments) {
        Assert.isTrue(arguments.length == this.parameters.length, "Method argument mismatch");
        int i2 = 0;
        while (i2 < arguments.length) {
            Object value = arguments[i2];
            boolean resolved = false;
            for (HttpServiceArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.resolve(value, this.parameters[i2], requestValues)) continue;
                resolved = true;
                break;
            }
            int index = i2++;
            Assert.state(resolved, () -> "Could not resolve parameter [" + this.parameters[index].getParameterIndex() + "] in " + this.parameters[index].getExecutable().toGenericString() + (StringUtils.hasText("No suitable resolver") ? ": No suitable resolver" : ""));
        }
    }

    private record HttpRequestValuesInitializer(@Nullable HttpMethod httpMethod, @Nullable String url, @Nullable MediaType contentType, @Nullable List<MediaType> acceptMediaTypes, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
        public HttpRequestValues.Builder initializeRequestValuesBuilder() {
            HttpRequestValues.Builder requestValues = this.requestValuesSupplier.get();
            if (this.httpMethod != null) {
                requestValues.setHttpMethod(this.httpMethod);
            }
            if (this.url != null) {
                requestValues.setUriTemplate(this.url);
            }
            if (this.contentType != null) {
                requestValues.setContentType(this.contentType);
            }
            if (this.acceptMediaTypes != null) {
                requestValues.setAccept(this.acceptMediaTypes);
            }
            return requestValues;
        }

        public static HttpRequestValuesInitializer create(Method method, Class<?> containingClass, @Nullable StringValueResolver embeddedValueResolver, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
            HttpExchange annot1 = AnnotatedElementUtils.findMergedAnnotation(containingClass, HttpExchange.class);
            HttpExchange annot2 = AnnotatedElementUtils.findMergedAnnotation(method, HttpExchange.class);
            Assert.notNull((Object)annot2, "Expected HttpRequest annotation");
            HttpMethod httpMethod = HttpRequestValuesInitializer.initHttpMethod(annot1, annot2);
            String url = HttpRequestValuesInitializer.initUrl(annot1, annot2, embeddedValueResolver);
            MediaType contentType = HttpRequestValuesInitializer.initContentType(annot1, annot2);
            List<MediaType> acceptableMediaTypes = HttpRequestValuesInitializer.initAccept(annot1, annot2);
            return new HttpRequestValuesInitializer(httpMethod, url, contentType, acceptableMediaTypes, requestValuesSupplier);
        }

        @Nullable
        private static HttpMethod initHttpMethod(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            String value1 = typeAnnot != null ? typeAnnot.method() : null;
            String value2 = annot.method();
            if (StringUtils.hasText(value2)) {
                return HttpMethod.valueOf(value2);
            }
            if (StringUtils.hasText(value1)) {
                return HttpMethod.valueOf(value1);
            }
            return null;
        }

        @Nullable
        private static String initUrl(@Nullable HttpExchange typeAnnot, HttpExchange annot, @Nullable StringValueResolver embeddedValueResolver) {
            String url1 = typeAnnot != null ? typeAnnot.url() : null;
            String url2 = annot.url();
            if (embeddedValueResolver != null) {
                url1 = url1 != null ? embeddedValueResolver.resolveStringValue(url1) : null;
                url2 = embeddedValueResolver.resolveStringValue(url2);
            }
            boolean hasUrl1 = StringUtils.hasText(url1);
            boolean hasUrl2 = StringUtils.hasText(url2);
            if (hasUrl1 && hasUrl2) {
                return url1 + (!url1.endsWith("/") && !url2.startsWith("/") ? "/" : "") + url2;
            }
            if (!hasUrl1 && !hasUrl2) {
                return null;
            }
            return hasUrl2 ? url2 : url1;
        }

        @Nullable
        private static MediaType initContentType(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            String value1 = typeAnnot != null ? typeAnnot.contentType() : null;
            String value2 = annot.contentType();
            if (StringUtils.hasText(value2)) {
                return MediaType.parseMediaType(value2);
            }
            if (StringUtils.hasText(value1)) {
                return MediaType.parseMediaType(value1);
            }
            return null;
        }

        @Nullable
        private static List<MediaType> initAccept(@Nullable HttpExchange typeAnnot, HttpExchange annot) {
            Object[] value1 = typeAnnot != null ? typeAnnot.accept() : null;
            Object[] value2 = annot.accept();
            if (!ObjectUtils.isEmpty(value2)) {
                return MediaType.parseMediaTypes(Arrays.asList(value2));
            }
            if (!ObjectUtils.isEmpty(value1)) {
                return MediaType.parseMediaTypes(Arrays.asList(value1));
            }
            return null;
        }
    }

    private record ReactorExchangeResponseFunction(Function<HttpRequestValues, Publisher<?>> responseFunction, @Nullable ReactiveAdapter returnTypeAdapter, boolean blockForOptional, @Nullable Duration blockTimeout) implements ResponseFunction
    {
        @Override
        @Nullable
        public Object execute(HttpRequestValues requestValues) {
            Publisher<?> responsePublisher = this.responseFunction.apply(requestValues);
            if (this.returnTypeAdapter != null) {
                return this.returnTypeAdapter.fromPublisher(responsePublisher);
            }
            if (this.blockForOptional) {
                return this.blockTimeout != null ? ((Mono)responsePublisher).blockOptional(this.blockTimeout) : ((Mono)responsePublisher).blockOptional();
            }
            return this.blockTimeout != null ? ((Mono)responsePublisher).block(this.blockTimeout) : ((Mono)responsePublisher).block();
        }

        /*
         * Enabled aggressive block sorting
         */
        public static ResponseFunction create(ReactorHttpExchangeAdapter client, Method method) {
            Function<HttpRequestValues, Publisher<?>> responseFunction;
            Class<?> actualType;
            MethodParameter actualParam;
            ReactiveAdapter reactiveAdapter;
            boolean isSuspending;
            Class<Object> returnType;
            block9: {
                block8: {
                    MethodParameter returnParam = new MethodParameter(method, -1);
                    returnType = returnParam.getParameterType();
                    isSuspending = KotlinDetector.isSuspendingFunction(method);
                    if (isSuspending) {
                        returnType = Mono.class;
                    }
                    actualParam = (reactiveAdapter = client.getReactiveAdapterRegistry().getAdapter(returnType)) != null ? returnParam.nested() : returnParam.nestedIfOptional();
                    Class<?> clazz = actualType = isSuspending ? actualParam.getParameterType() : actualParam.getNestedParameterType();
                    if (actualType.equals(Void.TYPE)) break block8;
                    if (!actualType.equals(Void.class)) break block9;
                }
                responseFunction = client::exchangeForMono;
                return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
            }
            if (reactiveAdapter != null && reactiveAdapter.isNoValue()) {
                responseFunction = client::exchangeForMono;
                return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
            }
            if (actualType.equals(HttpHeaders.class)) {
                responseFunction = client::exchangeForHeadersMono;
                return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
            }
            if (!actualType.equals(ResponseEntity.class)) {
                responseFunction = ReactorExchangeResponseFunction.initBodyFunction(client, actualParam, reactiveAdapter, isSuspending);
                return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
            }
            MethodParameter bodyParam = isSuspending ? actualParam : actualParam.nested();
            Class<?> bodyType = bodyParam.getNestedParameterType();
            if (bodyType.equals(Void.class)) {
                responseFunction = client::exchangeForBodilessEntityMono;
                return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
            }
            ReactiveAdapter bodyAdapter = client.getReactiveAdapterRegistry().getAdapter(bodyType);
            responseFunction = ReactorExchangeResponseFunction.initResponseEntityFunction(client, bodyParam, bodyAdapter, isSuspending);
            return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
        }

        private static Function<HttpRequestValues, Publisher<?>> initResponseEntityFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isSuspending) {
            if (reactiveAdapter == null) {
                return request -> client.exchangeForEntityMono((HttpRequestValues)request, ParameterizedTypeReference.forType(methodParam.getNestedGenericParameterType()));
            }
            Assert.isTrue(reactiveAdapter.isMultiValue(), "ResponseEntity body must be a concrete value or a multi-value Publisher");
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType(isSuspending ? methodParam.nested().getGenericParameterType() : methodParam.nested().getNestedGenericParameterType());
            if (reactiveAdapter.getReactiveType().equals(Flux.class)) {
                return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType);
            }
            return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType).map(entity -> {
                Object body2 = reactiveAdapter.fromPublisher((Publisher)entity.getBody());
                return new ResponseEntity<Object>(body2, (MultiValueMap<String, String>)entity.getHeaders(), entity.getStatusCode());
            });
        }

        private static Function<HttpRequestValues, Publisher<?>> initBodyFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isSuspending) {
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType(isSuspending ? methodParam.getGenericParameterType() : methodParam.getNestedGenericParameterType());
            return reactiveAdapter != null && reactiveAdapter.isMultiValue() ? request -> client.exchangeForBodyFlux((HttpRequestValues)request, bodyType) : request -> client.exchangeForBodyMono((HttpRequestValues)request, bodyType);
        }
    }

    private static interface ResponseFunction {
        @Nullable
        public Object execute(HttpRequestValues var1);
    }

    private record ExchangeResponseFunction(Function<HttpRequestValues, Object> responseFunction) implements ResponseFunction
    {
        @Override
        public Object execute(HttpRequestValues requestValues) {
            return this.responseFunction.apply(requestValues);
        }

        public static ResponseFunction create(HttpExchangeAdapter client, Method method) {
            Function<HttpRequestValues, Object> responseFunction;
            if (KotlinDetector.isSuspendingFunction(method)) {
                throw new IllegalStateException("Kotlin Coroutines are only supported with reactive implementations");
            }
            MethodParameter param = new MethodParameter(method, -1).nestedIfOptional();
            Class<?> paramType = param.getNestedParameterType();
            if (paramType.equals(Void.TYPE) || paramType.equals(Void.class)) {
                responseFunction = requestValues -> {
                    client.exchange((HttpRequestValues)requestValues);
                    return null;
                };
            } else if (paramType.equals(HttpHeaders.class)) {
                responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForHeaders((HttpRequestValues)request), param);
            } else if (paramType.equals(ResponseEntity.class)) {
                MethodParameter bodyParam = param.nested();
                if (bodyParam.getNestedParameterType().equals(Void.class)) {
                    responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForBodilessEntity((HttpRequestValues)request), param);
                } else {
                    ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType(bodyParam.getNestedGenericParameterType());
                    responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForEntity((HttpRequestValues)request, bodyTypeRef), param);
                }
            } else {
                ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType(param.getNestedGenericParameterType());
                responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForBody((HttpRequestValues)request, bodyTypeRef), param);
            }
            return new ExchangeResponseFunction(responseFunction);
        }

        @Nullable
        private static Object asOptionalIfNecessary(@Nullable Object response, MethodParameter param) {
            return param.getParameterType().equals(Optional.class) ? Optional.ofNullable(response) : response;
        }
    }
}

