/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.redeem.redeemcodes.Redeemcodes;
import com.redeem.redeemcodes.gui.CodeEditorGUI;
import com.redeem.redeemcodes.gui.MainGUI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class CreateCodeHandler
implements Listener {
    private final Redeemcodes plugin;
    private final Set<UUID> awaitingInput = new HashSet<UUID>();

    public CreateCodeHandler(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    public void startCodeCreation(Player player) {
        this.awaitingInput.add(player.getUniqueId());
        player.closeInventory();
        player.sendMessage("\u00a7aPlease type the name for your new code in chat.");
        player.sendMessage("\u00a77Type 'cancel' to abort.");
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.awaitingInput.contains(playerUUID)) {
            event.setCancelled(true);
            String input = event.getMessage().trim();
            if (input.equalsIgnoreCase("cancel")) {
                this.awaitingInput.remove(playerUUID);
                player.sendMessage("\u00a7cCode creation cancelled.");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.createCode(player, input));
            this.awaitingInput.remove(playerUUID);
            return;
        }
        CodeEditorGUI editor = this.plugin.openEditorGUIs.get(player);
        if (editor != null) {
            editor.handleChatInput(event);
        }
    }

    private void createCode(Player player, String codeName) {
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (codes.contains("Codes." + codeName)) {
            player.sendMessage("\u00a7cThat code already exists!");
            return;
        }
        codes.set("Codes." + codeName + ".enabled", (Object)true);
        codes.set("Codes." + codeName + ".permisson.required", (Object)false);
        codes.set("Codes." + codeName + ".permisson.list", new ArrayList());
        codes.set("Codes." + codeName + ".redeem-limit.Type", (Object)"PLAYER");
        codes.set("Codes." + codeName + ".redeem-limit.Count", (Object)1);
        codes.set("Codes." + codeName + ".redeem-limit.Cooldown", (Object)0);
        codes.set("Codes." + codeName + ".Playerlist.Used", new ArrayList());
        codes.set("Codes." + codeName + ".Playerlist.Blacklist.Type", (Object)"ENABLED");
        codes.set("Codes." + codeName + ".Playerlist.Blacklist.List", new ArrayList());
        codes.set("Codes." + codeName + ".rewards", new ArrayList());
        this.plugin.saveCodesConfig();
        player.sendMessage("\u00a7aCode \u00a7e" + codeName + " \u00a7ahas been created!");
        MainGUI.open(player);
    }
}

