/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import com.redeem.redeemcodes.RedeemCodesCommand;
import com.redeem.redeemcodes.RedeemCommand;
import com.redeem.redeemcodes.RedeemDataManager;
import com.redeem.redeemcodes.gui.CodeEditorGUI;
import com.redeem.redeemcodes.gui.CodesListGUI;
import com.redeem.redeemcodes.gui.CreateCodeHandler;
import com.redeem.redeemcodes.gui.GUIListener;
import com.redeem.redeemcodes.gui.HeadManager;
import com.redeem.redeemcodes.gui.MainGUI;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Redeemcodes
extends JavaPlugin {
    private FileConfiguration codesConfig;
    private File codesFile;
    private RedeemDataManager redeemDataManager;
    public final Map<Player, CodesListGUI> openCodeGUIs = new HashMap<Player, CodesListGUI>();
    public Map<Player, CodeEditorGUI> openEditorGUIs = new HashMap<Player, CodeEditorGUI>();

    public void onEnable() {
        PluginCommand redeemcodesCommand;
        this.saveDefaultConfig();
        this.createCodesConfig();
        HeadManager.preloadHeads();
        this.redeemDataManager = new RedeemDataManager(this);
        PluginCommand redeemCommand = this.getCommand("redeem");
        if (redeemCommand != null) {
            redeemCommand.setExecutor((CommandExecutor)new RedeemCommand(this));
        }
        if ((redeemcodesCommand = this.getCommand("redeemcodes")) != null) {
            redeemcodesCommand.setExecutor((CommandExecutor)new RedeemCodesCommand(this));
        }
        final CreateCodeHandler createHandler = new CreateCodeHandler(this);
        this.getServer().getPluginManager().registerEvents((Listener)createHandler, (Plugin)this);
        Bukkit.getPluginManager().registerEvents(new Listener(){
            final /* synthetic */ Redeemcodes this$0;
            {
                this.this$0 = this$0;
            }

            @EventHandler
            public void onInventoryClick(InventoryClickEvent event) {
                MainGUI.handleClick(event, this.this$0, createHandler);
            }
        }, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this, createHandler), (Plugin)this);
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.GREEN) + "[RedeemCodes] Plugin Enabled!");
    }

    public void onDisable() {
        if (this.redeemDataManager != null) {
            this.redeemDataManager.saveFile();
        }
        Bukkit.getConsoleSender().sendMessage(String.valueOf(ChatColor.RED) + "[RedeemCodes] Plugin Disabled!");
    }

    public void sendToWebhook(String webhookUrl, String jsonPayload) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                URL url = new URL(webhookUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("User-Agent", "Minecraft Plugin");
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode >= 300) {
                    this.getLogger().warning("Failed to send webhook message to " + webhookUrl + ". Response code: " + responseCode);
                }
                connection.disconnect();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not send webhook message: " + e.getMessage());
            }
        });
    }

    private void createCodesConfig() {
        this.codesFile = new File(this.getDataFolder(), "codes.yml");
        if (!this.codesFile.exists()) {
            this.saveResource("codes.yml", false);
        }
        this.codesConfig = YamlConfiguration.loadConfiguration((File)this.codesFile);
    }

    public void reloadCodesConfig() {
        this.codesFile = new File(this.getDataFolder(), "codes.yml");
        this.codesConfig = YamlConfiguration.loadConfiguration((File)this.codesFile);
    }

    public FileConfiguration getCodesConfig() {
        return this.codesConfig;
    }

    public void saveCodesConfig() {
        try {
            this.codesConfig.save(this.codesFile);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    public RedeemDataManager getRedeemDataManager() {
        return this.redeemDataManager;
    }

    public String color(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public String getPrefix() {
        return this.getConfig().getString("prefix", "&7[RedeemCodes] ");
    }
}

