/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.redeem.redeemcodes.Redeemcodes;
import com.redeem.redeemcodes.gui.CodeEditorGUI;
import com.redeem.redeemcodes.gui.CodesListGUI;
import com.redeem.redeemcodes.gui.CreateCodeHandler;
import com.redeem.redeemcodes.gui.MainGUI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GUIListener
implements Listener {
    private final Redeemcodes plugin;
    private final CreateCodeHandler createHandler;

    public GUIListener(Redeemcodes plugin, CreateCodeHandler createHandler) {
        this.plugin = plugin;
        this.createHandler = createHandler;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().contains("Redeem Codes")) {
            CodesListGUI gui = this.plugin.openCodeGUIs.get(player);
            if (gui != null) {
                gui.handleClick(event, player);
            }
        } else if (event.getView().getTitle().contains("Edit Code:")) {
            CodeEditorGUI editor = this.plugin.openEditorGUIs.get(player);
            if (editor != null) {
                String name;
                editor.handleClick(event, player);
                ItemStack clicked = event.getCurrentItem();
                if (clicked != null && clicked.hasItemMeta() && clicked.getItemMeta().hasDisplayName() && (name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName())).equals("Back to Codes List")) {
                    this.plugin.openEditorGUIs.remove(player);
                }
            }
        } else {
            MainGUI.handleClick(event, this.plugin, this.createHandler);
        }
    }
}

