/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerTextures;

public class HeadManager {
    private static final Map<String, ItemStack> cachedHeads = new HashMap<String, ItemStack>();

    public static void preloadHeads() {
        HeadManager.register("CREATE", "ab478a4b2622ee44e81ad019f5302985659de8c382d29f0ef21e993d43d87d3");
        HeadManager.register("LIST", "6f9c7e59a2cebc0584f3bf71bbdaaf199c4921c2310723efdcb4eb6bcb9a13fc");
        HeadManager.register("ADMIN", "cfd3f7d43d360923b1c04445b01022466b50ca58df9893267121081e0c1e2f4e");
        HeadManager.register("CLOSE", "beb588b21a6f98ad1ff4e085c552dcb050efc9cab427f46048f18fc803475f7");
        HeadManager.register("CODE_ITEM", "ca18def035f87f7616404978208926be7476b579dfa360f0c2269ef2d4029c");
        HeadManager.register("BACK", "223fb67429716b21bc6e8e7d669ceddf65b13e0790a5ce55b2e077b82d19e124");
        HeadManager.register("NEXT_PAGE", "8271a47104495e357c3e8e80f511a9f102b0700ca9b88e88b795d33ff20105eb");
        HeadManager.register("PREV_PAGE", "69ea1d86247f4af351ed1866bca6a3040a06c68177c78e42316a1098e60fb7d3");
    }

    private static void register(String key, String textureId) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            try {
                org.bukkit.profile.PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
                PlayerTextures textures = profile.getTextures();
                textures.setSkin(new URL("https://textures.minecraft.net/texture/" + textureId));
                profile.setTextures(textures);
                meta.setPlayerProfile((PlayerProfile)profile);
                head.setItemMeta((ItemMeta)meta);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        cachedHeads.put(key, head);
    }

    public static ItemStack getHead(String key, String displayName, String ... lore) {
        ItemStack base = cachedHeads.get(key);
        if (base == null) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        ItemStack clone = base.clone();
        SkullMeta meta = (SkullMeta)clone.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            if (lore != null && lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            clone.setItemMeta((ItemMeta)meta);
        }
        return clone;
    }
}

