/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import com.redeem.redeemcodes.Redeemcodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class RedeemCodesCommand
implements CommandExecutor,
TabCompleter {
    private final Redeemcodes plugin;

    public RedeemCodesCommand(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    private void playSuccessSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }

    private void playFailureSound(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 1.0f, 0.5f);
    }

    private String getMessage(String path) {
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("prefix", ""));
        String raw = this.plugin.getConfig().getString("messages." + path, "&cMessage not found: " + path);
        return prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)raw);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            this.plugin.reloadConfig();
            this.plugin.createCustomConfig();
            sender.sendMessage(this.getMessage("reload-success"));
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.playSuccessSound(player);
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (!player.isOp()) {
            player.sendMessage(this.getMessage("no-permission"));
            this.playFailureSound(player);
            return true;
        }
        if (!label.equalsIgnoreCase("rc") && !label.equalsIgnoreCase("redeemcodes")) {
            sender.sendMessage(this.getMessage("invalid-command"));
            return true;
        }
        if (args.length >= 2) {
            String action = args[0].toLowerCase();
            String codeName = args[1];
            FileConfiguration codes = this.plugin.getCodesConfig();
            switch (action) {
                case "create": {
                    if (codes.contains("codes." + codeName)) {
                        player.sendMessage(this.getMessage("code-exists"));
                        this.playFailureSound(player);
                        break;
                    }
                    codes.set("codes." + codeName + ".playerlist.used", new ArrayList());
                    codes.set("codes." + codeName + ".playerlist.blacklist", new ArrayList());
                    codes.set("codes." + codeName + ".rewards", new ArrayList());
                    codes.set("codes." + codeName + ".usetype", (Object)"once");
                    codes.set("codes." + codeName + ".uselimit", (Object)1);
                    this.plugin.saveCodesConfig();
                    player.sendMessage(this.getMessage("code-created").replace("%code%", codeName));
                    this.playSuccessSound(player);
                    break;
                }
                case "remove": {
                    if (!codes.contains("codes." + codeName)) {
                        player.sendMessage(this.getMessage("code-not-found"));
                        this.playFailureSound(player);
                        break;
                    }
                    codes.set("codes." + codeName, null);
                    this.plugin.saveCodesConfig();
                    player.sendMessage(this.getMessage("code-removed").replace("%code%", codeName));
                    this.playSuccessSound(player);
                    break;
                }
                case "addreward": {
                    if (args.length < 4) break;
                    int id = Integer.parseInt(args[2]);
                    String commandStr = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
                    List rewards = codes.getStringList("codes." + codeName + ".rewards");
                    while (rewards.size() <= id) {
                        rewards.add("");
                    }
                    rewards.set(id, commandStr);
                    codes.set("codes." + codeName + ".rewards", (Object)rewards);
                    this.plugin.saveCodesConfig();
                    player.sendMessage(this.getMessage("reward-added").replace("%id%", String.valueOf(id)).replace("%code%", codeName));
                    this.playSuccessSound(player);
                    break;
                }
                case "removereward": {
                    if (args.length < 3) break;
                    int id = Integer.parseInt(args[2]);
                    List rewards = codes.getStringList("codes." + codeName + ".rewards");
                    if (id >= 0 && id < rewards.size()) {
                        rewards.remove(id);
                        codes.set("codes." + codeName + ".rewards", (Object)rewards);
                        this.plugin.saveCodesConfig();
                        player.sendMessage(this.getMessage("reward-removed").replace("%id%", String.valueOf(id)));
                        this.playSuccessSound(player);
                        break;
                    }
                    player.sendMessage(this.getMessage("reward-not-found"));
                    this.playFailureSound(player);
                    break;
                }
                case "clear": {
                    List usedList = codes.getStringList("codes." + codeName + ".playerlist.used");
                    if (args.length == 3) {
                        String username = args[2];
                        usedList.remove(username);
                        player.sendMessage(this.getMessage("used-cleared-player").replace("%player%", username).replace("%code%", codeName));
                    } else {
                        usedList.clear();
                        player.sendMessage(this.getMessage("used-cleared-all").replace("%code%", codeName));
                    }
                    codes.set("codes." + codeName + ".playerlist.used", (Object)usedList);
                    this.plugin.saveCodesConfig();
                    this.playSuccessSound(player);
                    break;
                }
                case "blacklist": {
                    if (args.length != 3) break;
                    String username = args[2];
                    List blacklist = codes.getStringList("codes." + codeName + ".playerlist.blacklist");
                    if (blacklist.contains(username)) break;
                    blacklist.add(username);
                    codes.set("codes." + codeName + ".playerlist.blacklist", (Object)blacklist);
                    this.plugin.saveCodesConfig();
                    player.sendMessage(this.getMessage("player-blacklisted").replace("%player%", username).replace("%code%", codeName));
                    this.playSuccessSound(player);
                    break;
                }
                case "usetype": {
                    if (args.length != 4) break;
                    String type = args[2];
                    int limit = Integer.parseInt(args[3]);
                    codes.set("codes." + codeName + ".usetype", (Object)type);
                    codes.set("codes." + codeName + ".uselimit", (Object)limit);
                    this.plugin.saveCodesConfig();
                    player.sendMessage(this.getMessage("usetype-set").replace("%type%", type).replace("%limit%", String.valueOf(limit)));
                    this.playSuccessSound(player);
                    break;
                }
                default: {
                    player.sendMessage(this.getMessage("unknown-action").replace("%action%", action));
                    this.playFailureSound(player);
                }
            }
            return true;
        }
        player.sendMessage(this.getMessage("command-usage"));
        this.playFailureSound(player);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            suggestions.addAll(Arrays.asList("create", "remove", "addreward", "removereward", "clear", "blacklist", "usetype", "reload"));
        }
        return suggestions;
    }
}

