/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import com.redeem.redeemcodes.Redeemcodes;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class RedeemCommand
implements CommandExecutor {
    private final Redeemcodes plugin;

    public RedeemCommand(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    private String parsePlaceholders(String input, Player player) {
        input = input.replace("%player%", player.getName());
        input = input.replace("%uuid%", player.getUniqueId().toString());
        input = input.replace("%displayname%", player.getDisplayName());
        input = input.replace("%world%", player.getWorld().getName());
        Pattern pattern = Pattern.compile("%random-(\\d+)-(\\d+)%");
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        while (matcher.find()) {
            int min = Integer.parseInt(matcher.group(1));
            int max = Integer.parseInt(matcher.group(2));
            int rand = min + random.nextInt(max - min + 1);
            matcher.appendReplacement(sb, String.valueOf(rand));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void playSound(Player player, String path) {
        String soundName = this.plugin.getConfig().getString(path);
        if (soundName == null) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundName.toUpperCase());
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            Bukkit.getLogger().warning("[Redeemcodes] Invalid sound in config: " + soundName);
        }
    }

    private void sendMessage(Player player, String key) {
        String msg = this.plugin.getConfig().getString("messages." + key, "&cMessage not found: " + key);
        player.sendMessage(this.plugin.getPrefix() + msg.replace("&", "\u00a7"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("[Redeemcodes] Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            this.sendMessage(player, "usage");
            this.playSound(player, "sounds.failure");
            return true;
        }
        String code = args[0];
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (!codes.contains("codes." + code)) {
            this.sendMessage(player, "not-exist");
            this.playSound(player, "sounds.failure");
            return true;
        }
        List used = codes.getStringList("codes." + code + ".playerlist.used");
        List blacklist = codes.getStringList("codes." + code + ".playerlist.blacklist");
        if (blacklist.contains(player.getName())) {
            this.sendMessage(player, "blacklisted");
            this.playSound(player, "sounds.failure");
            return true;
        }
        if (used.contains(player.getName())) {
            this.sendMessage(player, "already-used");
            this.playSound(player, "sounds.failure");
            return true;
        }
        List rewards = codes.getStringList("codes." + code + ".rewards");
        for (String reward : rewards) {
            String parsedCommand = this.parsePlaceholders(reward, player);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsedCommand);
        }
        used.add(player.getName());
        codes.set("codes." + code + ".playerlist.used", (Object)used);
        this.plugin.saveCodesConfig();
        this.sendMessage(player, "redeem-success");
        this.playSound(player, "sounds.success");
        return true;
    }
}

