/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PluginUpdateChecker {
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/redeemcodes/version";
    private static final String MODRINTH_PROJECT_URL = "https://modrinth.com/plugin/redeemcodes";
    private final JavaPlugin plugin;
    private final String currentVersion;

    public PluginUpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void checkForUpdates() {
        new BukkitRunnable(){

            public void run() {
                try {
                    String latestVersion = PluginUpdateChecker.this.getLatestVersionFromModrinth();
                    if (latestVersion != null) {
                        PluginUpdateChecker.this.compareVersions(latestVersion);
                    } else {
                        PluginUpdateChecker.this.plugin.getLogger().warning("Could not check for plugin updates. Modrinth API unavailable.");
                    }
                }
                catch (Exception e) {
                    PluginUpdateChecker.this.plugin.getLogger().warning("Failed to check for plugin updates: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLatestVersionFromModrinth() {
        try {
            HttpURLConnection connection;
            block10: {
                URL url = new URL(MODRINTH_API_URL);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "RedeemCodes-Plugin/" + this.currentVersion);
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                        String line;
                        StringBuilder response = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            response.append(line);
                        }
                        String jsonResponse = response.toString();
                        Pattern pattern = Pattern.compile("\"version_number\"\\s*:\\s*\"([^\"]+)\"");
                        Matcher matcher = pattern.matcher(jsonResponse);
                        if (matcher.find()) {
                            String string = matcher.group(1);
                            return string;
                        }
                        break block10;
                    }
                }
                this.plugin.getLogger().warning("Modrinth API returned HTTP " + responseCode);
            }
            connection.disconnect();
            return null;
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to connect to Modrinth API: " + e.getMessage());
        }
        return null;
    }

    private void compareVersions(String latestVersion) {
        if (this.isNewerVersion(latestVersion, this.currentVersion)) {
            this.plugin.getLogger().warning("========================================");
            this.plugin.getLogger().warning("PLUGIN UPDATE AVAILABLE!");
            this.plugin.getLogger().warning("Current version: " + this.currentVersion);
            this.plugin.getLogger().warning("Latest version: " + latestVersion);
            this.plugin.getLogger().warning("Please download the latest version:");
            this.plugin.getLogger().warning(MODRINTH_PROJECT_URL);
            this.plugin.getLogger().warning("========================================");
            this.notifyOperators(latestVersion);
        } else {
            this.plugin.getLogger().info("Plugin is up to date (v" + this.currentVersion + ") \u2713");
        }
    }

    private boolean isNewerVersion(String versionA, String versionB) {
        try {
            String[] partsA = versionA.split("\\.");
            String[] partsB = versionB.split("\\.");
            int length = Math.max(partsA.length, partsB.length);
            for (int i = 0; i < length; ++i) {
                int numB;
                int numA = i < partsA.length ? Integer.parseInt(partsA[i]) : 0;
                int n = numB = i < partsB.length ? Integer.parseInt(partsB[i]) : 0;
                if (numA > numB) {
                    return true;
                }
                if (numA >= numB) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Failed to compare versions: " + versionA + " vs " + versionB);
            return false;
        }
    }

    private void notifyOperators(final String latestVersion) {
        new BukkitRunnable(this){
            final /* synthetic */ PluginUpdateChecker this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Bukkit.getOnlinePlayers().stream().filter(player -> player.isOp() || player.hasPermission("redeemcodes.admin")).forEach(player -> {
                    player.sendMessage(this.this$0.plugin.getConfig().getString("prefix", "&7[RedeemCodes] ") + "\u00a7eA new plugin update is available! (v" + latestVersion + ")");
                    player.sendMessage(this.this$0.plugin.getConfig().getString("prefix", "&7[RedeemCodes] ") + "\u00a7eDownload: https://modrinth.com/plugin/redeemcodes");
                });
            }
        }.runTask((Plugin)this.plugin);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }
}

