/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import com.redeem.redeemcodes.Redeemcodes;
import com.redeem.redeemcodes.gui.MainGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class RedeemCodesCommand
implements CommandExecutor,
TabCompleter {
    private final Redeemcodes plugin;

    public RedeemCodesCommand(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    private void playSound(Player player, String path) {
        String soundName = this.plugin.getConfig().getString(path);
        if (soundName == null || soundName.isEmpty()) {
            return;
        }
        Sound sound = null;
        try {
            NamespacedKey key = NamespacedKey.fromString((String)soundName.toLowerCase());
            sound = Sound.valueOf((String)key.getKey().toUpperCase().replace('.', '_'));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (sound == null) {
            try {
                sound = Sound.valueOf((String)soundName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (sound != null) {
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        } else {
            this.plugin.getLogger().warning("The sound '" + soundName + "' specified at config path '" + path + "' is not a valid sound.");
        }
    }

    private String getMessage(String key) {
        return this.plugin.color(this.plugin.getPrefix() + this.plugin.getConfig().getString("messages." + key, "&cMessage not found: " + key));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use admin commands.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.isOp() && !player.hasPermission("redeemcodes.admin")) {
            player.sendMessage(this.getMessage("no-permission"));
            this.playSound(player, "sounds.failure");
            return true;
        }
        if (args.length < 1) {
            this.sendgui(player);
            return true;
        }
        String action = args[0].toLowerCase();
        FileConfiguration codes = this.plugin.getCodesConfig();
        switch (action) {
            case "reload": {
                this.plugin.reloadConfig();
                this.plugin.reloadCodesConfig();
                player.sendMessage(this.getMessage("reload-success"));
                this.playSound(player, "sounds.success");
                break;
            }
            case "gui": {
                this.sendgui(player);
                break;
            }
            case "create": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /rc create <code>");
                    return true;
                }
                String codeCreate = args[1];
                if (codes.contains("Codes." + codeCreate)) {
                    player.sendMessage(this.getMessage("code-exists"));
                    this.playSound(player, "sounds.failure");
                    break;
                }
                codes.set("Codes." + codeCreate + ".enabled", (Object)true);
                codes.set("Codes." + codeCreate + ".permisson.required", (Object)false);
                codes.set("Codes." + codeCreate + ".permisson.list", new ArrayList());
                codes.set("Codes." + codeCreate + ".redeem-limit.Type", (Object)"PLAYER");
                codes.set("Codes." + codeCreate + ".redeem-limit.Count", (Object)1);
                codes.set("Codes." + codeCreate + ".redeem-limit.Cooldown", (Object)0);
                codes.set("Codes." + codeCreate + ".Playerlist.Used", new ArrayList());
                codes.set("Codes." + codeCreate + ".Playerlist.Blacklist.Type", (Object)"ENABLED");
                codes.set("Codes." + codeCreate + ".Playerlist.Blacklist.List", new ArrayList());
                codes.set("Codes." + codeCreate + ".rewards", new ArrayList());
                this.plugin.saveCodesConfig();
                player.sendMessage(this.getMessage("code-created").replace("%code%", codeCreate));
                player.sendMessage(this.plugin.color("&e[*] In-game editor is now available. Use command /rc"));
                this.playSound(player, "sounds.success");
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /rc remove <code>");
                    return true;
                }
                String codeRemove = args[1];
                if (!codes.contains("Codes." + codeRemove)) {
                    player.sendMessage("\u00a7cThis code doesn't exist.");
                    return true;
                }
                codes.set("Codes." + codeRemove, null);
                this.plugin.saveCodesConfig();
                player.sendMessage(this.plugin.color("&aCode removed: &c" + codeRemove));
                this.playSound(player, "sounds.success");
                break;
            }
            case "addreward": {
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /rc addreward <code> <reward>");
                    return true;
                }
                String codeAdd = args[1];
                if (!codes.contains("Codes." + codeAdd)) {
                    player.sendMessage("\u00a7cThis code doesn't exist.");
                    return true;
                }
                String reward = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                List rewards = codes.getStringList("Codes." + codeAdd + ".rewards");
                rewards.add(reward);
                codes.set("Codes." + codeAdd + ".rewards", (Object)rewards);
                this.plugin.saveCodesConfig();
                player.sendMessage(this.getMessage("reward-added").replace("%code%", codeAdd).replace("%id%", String.valueOf(rewards.size() - 1)));
                this.playSound(player, "sounds.success");
                break;
            }
            case "removereward": {
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /rc removereward <code> <id>");
                    return true;
                }
                String codeRemoveReward = args[1];
                if (!codes.contains("Codes." + codeRemoveReward)) {
                    player.sendMessage("\u00a7cThis code doesn't exist.");
                    return true;
                }
                try {
                    int id = Integer.parseInt(args[2]);
                    List rewards = codes.getStringList("Codes." + codeRemoveReward + ".rewards");
                    if (id >= 0 && id < rewards.size()) {
                        rewards.remove(id);
                        codes.set("Codes." + codeRemoveReward + ".rewards", (Object)rewards);
                        this.plugin.saveCodesConfig();
                        player.sendMessage(this.getMessage("reward-removed").replace("%id%", String.valueOf(id)));
                        this.playSound(player, "sounds.success");
                        break;
                    }
                    player.sendMessage("\u00a7cReward ID doesn't exist.");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid reward ID.");
                }
                break;
            }
            case "help": {
                this.sendHelp(player, args);
                break;
            }
            case "list": {
                this.sendCodeList(player);
                break;
            }
            case "version": {
                player.sendMessage(this.plugin.color("&bRedeemCodes Version: &f" + this.plugin.getDescription().getVersion()));
                break;
            }
            case "show": {
                this.showCodeDetails(player, args);
                break;
            }
            case "rewards": {
                this.sendRewardsList(player, args);
                break;
            }
            case "redeemed": {
                this.sendRedeemedList(player, args);
                break;
            }
            case "review": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /rc review <message>");
                    return true;
                }
                if (this.plugin.getConfig().getBoolean("send-review.review-message", true)) {
                    String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                    String playerName = player.getName();
                    String webhookUrl = "https://discord.com/api/webhooks/1415900269459542048/FNd7DLkVp2x2zdTs2b7f0UwbHA96MgeM0MpLne4Wst1k818HaarInJaSz2oNO_pcg6VJ";
                    String jsonPayload = "{\"embeds\": [{\"title\": \"New Plugin Review\",\"color\": 15844367,\"fields\": [  {\"name\": \"Player\",\"value\": \"" + playerName + "\",\"inline\": true},  {\"name\": \"Message\",\"value\": \"" + message.replace("\"", "\\\"") + "\",\"inline\": false}],\"footer\": {\"text\": \"RedeemCodes Review System\"}}]}";
                    this.plugin.sendToWebhook(webhookUrl, jsonPayload);
                    player.sendMessage(this.plugin.color("&aThank you! Your review has been sent."));
                    this.playSound(player, "sounds.success");
                    break;
                }
                player.sendMessage(this.plugin.color("&cThe server owner has disabled this feature."));
                break;
            }
            default: {
                if (action.isEmpty()) {
                    if (!player.isOp() && !player.hasPermission("redeemcodes.admin")) {
                        player.sendMessage(this.getMessage("no-permission"));
                        this.playSound(player, "sounds.failure");
                        break;
                    }
                    player.sendMessage(this.plugin.color("&e[!] GUI feature is &cComing Soon..."));
                    this.playSound(player, "sounds.success");
                    break;
                }
                player.sendMessage(this.getMessage("unknown-action").replace("%action%", action));
                this.playSound(player, "sounds.failure");
            }
        }
        return true;
    }

    private void sendgui(Player player) {
        if (!player.isOp() && !player.hasPermission("redeemcodes.admin")) {
            player.sendMessage(this.getMessage("no-permission"));
            this.playSound(player, "sounds.failure");
        } else {
            MainGUI.open(player);
            this.playSound(player, "sounds.success");
        }
    }

    private void showCodeDetails(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /rc show <code>");
            return;
        }
        String code = args[1];
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (!codes.contains("Codes." + code)) {
            player.sendMessage("\u00a7cThis code doesn't exist.");
            return;
        }
        player.sendMessage(this.plugin.color("&d---- &bCode Details: &f" + code + " &d----"));
        player.sendMessage(this.plugin.color("&7Enabled: " + (codes.getBoolean("Codes." + code + ".enabled", true) ? "&aTrue" : "&cFalse")));
        player.sendMessage(this.plugin.color("&7Permission Required: " + (codes.getBoolean("Codes." + code + ".permisson.required", false) ? "&aYes" : "&cNo")));
        player.sendMessage(this.plugin.color("&7Cooldown: &b" + codes.getInt("Codes." + code + ".redeem-limit.Cooldown", 0) + " minutes"));
        player.sendMessage(this.plugin.color("&7Redeem Type: &b" + codes.getString("Codes." + code + ".redeem-limit.Type", "PLAYER")));
        player.sendMessage(this.plugin.color("&7Redeem Limit: &b" + codes.getInt("Codes." + code + ".redeem-limit.Count", 1)));
        player.sendMessage(this.plugin.color("&7Rewards:"));
        List rewards = codes.getStringList("Codes." + code + ".rewards");
        if (rewards.isEmpty()) {
            player.sendMessage(this.plugin.color("&c- No rewards set."));
        } else {
            for (int i = 0; i < rewards.size(); ++i) {
                player.sendMessage(this.plugin.color("&b  #" + i + ": &7" + (String)rewards.get(i)));
            }
        }
    }

    private void sendHelp(Player player, String[] args) {
        int commandIndex;
        List<String> helpCommands = Arrays.asList("&b/rc create <code> &7- Create a new code", "&b/rc remove <code> &7- Remove a code", "&b/rc addreward <code> <command> &7- Add a reward to a code", "&b/rc removereward <code> <id> &7- Remove a reward by ID", "&b/rc show <code> &7- Show details of a code", "&b/rc rewards <code> [page] &7- View and manage code rewards", "&b/rc redeemed <code> [page] &7- List players who used a code", "&b/rc list &7- List all codes", "&b/rc reload &7- Reload plugin configs", "&b/rc version &7- View plugin version", "&b/rc review <message> &7- Send a plugin review or bug report to makers", "&b/rc gui &7- Open Redeemcodes gui", "&b/rc help [page] &7- Show this help menu");
        int commandsPerPage = 6;
        int totalPages = (int)Math.ceil((double)helpCommands.size() / (double)commandsPerPage);
        int page = 1;
        if (args.length > 1) {
            try {
                page = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                page = 1;
            }
        }
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        boolean hasPrev = page > 1;
        boolean hasNext = page < totalPages;
        TextComponent header = new TextComponent();
        if (hasPrev) {
            TextComponent prevButton = new TextComponent(this.plugin.color("&e\u00ab PREV"));
            prevButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc help " + (page - 1)));
            prevButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Go to Page " + (page - 1)).color(ChatColor.YELLOW).create()));
            header.addExtra((BaseComponent)prevButton);
        } else {
            header.addExtra(this.plugin.color("&7\u00ab PREV"));
        }
        header.addExtra(this.plugin.color(" &d&lRedeemCodes Help &r&d- Page " + page + "/" + totalPages));
        if (hasNext) {
            TextComponent nextButton = new TextComponent(this.plugin.color("&aNEXT \u00bb"));
            nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc help " + (page + 1)));
            nextButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Go to Page " + (page + 1)).color(ChatColor.GREEN).create()));
            header.addExtra((BaseComponent)nextButton);
        } else {
            header.addExtra(this.plugin.color("&7NEXT \u00bb"));
        }
        player.sendMessage(this.plugin.color(" "));
        player.sendMessage(this.plugin.color("&e&m                                                                       "));
        player.spigot().sendMessage((BaseComponent)header);
        player.sendMessage(this.plugin.color(" "));
        int startIndex = (page - 1) * commandsPerPage;
        for (int i = 0; i < commandsPerPage && (commandIndex = startIndex + i) < helpCommands.size(); ++i) {
            player.sendMessage(this.plugin.color(helpCommands.get(commandIndex)));
        }
        player.sendMessage(this.plugin.color("&e&m                                                                       "));
    }

    private void sendCodeList(Player player) {
        FileConfiguration codes = this.plugin.getCodesConfig();
        Set codeNames = codes.getConfigurationSection("Codes").getKeys(false);
        player.sendMessage(this.plugin.color("&d---- &bList of Existing Codes &d----"));
        for (String code : codeNames) {
            boolean enabled = codes.getBoolean("Codes." + code + ".enabled", true);
            TextComponent component = new TextComponent(this.plugin.color((enabled ? "&a" : "&c") + "\u27a4 " + code));
            component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc show " + code));
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to view details").create()));
            player.spigot().sendMessage((BaseComponent)component);
        }
    }

    private void sendRewardsList(Player player, String[] args) {
        int rewardIndex;
        String codePath;
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /rc rewards <code> [page]");
            return;
        }
        String codeName = args[1];
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (!codes.contains(codePath = "Codes." + codeName)) {
            player.sendMessage("\u00a7cThis code doesn't exist.");
            return;
        }
        List rewards = codes.getStringList(codePath + ".rewards");
        if (rewards.isEmpty()) {
            player.sendMessage(this.plugin.color("&cNo rewards found for code '&e" + codeName + "&c'."));
            return;
        }
        int page = 1;
        if (args.length >= 3) {
            try {
                page = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cInvalid page number.");
                return;
            }
        }
        int itemsPerPage = 10;
        int totalPages = (int)Math.ceil((double)rewards.size() / (double)itemsPerPage);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages && totalPages > 0) {
            page = totalPages;
        }
        boolean hasNext = page < totalPages;
        boolean hasPrev = page > 1;
        TextComponent header = new TextComponent();
        if (hasPrev) {
            TextComponent prevButton = new TextComponent(this.plugin.color("  &e\u00ab PREV  "));
            prevButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc rewards " + codeName + " " + (page - 1)));
            prevButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Go to Page " + (page - 1)).color(ChatColor.YELLOW).create()));
            header.addExtra((BaseComponent)prevButton);
        } else {
            header.addExtra(this.plugin.color("&7\u00ab PREV"));
        }
        header.addExtra(this.plugin.color(String.format(" &d&lCode Rewards &r&d- Page %d/%d ", page, totalPages)));
        if (hasNext) {
            TextComponent nextButton = new TextComponent(this.plugin.color("  &aNEXT \u00bb"));
            nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc rewards " + codeName + " " + (page + 1)));
            nextButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Go to Page " + (page + 1)).color(ChatColor.GREEN).create()));
            header.addExtra((BaseComponent)nextButton);
        } else {
            header.addExtra(this.plugin.color("&7NEXT \u00bb"));
        }
        player.sendMessage(this.plugin.color(" "));
        player.sendMessage(this.plugin.color("&e&m                                                                       "));
        player.spigot().sendMessage((BaseComponent)header);
        player.sendMessage(this.plugin.color(" "));
        int startIndex = (page - 1) * itemsPerPage;
        for (int i = 0; i < itemsPerPage && (rewardIndex = startIndex + i) < rewards.size(); ++i) {
            String reward = (String)rewards.get(rewardIndex);
            TextComponent rewardLine = new TextComponent(this.plugin.color("&b#" + rewardIndex + ": &7" + reward));
            TextComponent removeButton = new TextComponent(this.plugin.color(" &c[-]"));
            removeButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc removereward " + codeName + " " + rewardIndex));
            removeButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to remove this reward").color(ChatColor.RED).create()));
            rewardLine.addExtra((BaseComponent)removeButton);
            player.spigot().sendMessage((BaseComponent)rewardLine);
        }
        player.sendMessage(this.plugin.color("&e&m                                                                       "));
    }

    private void sendRedeemedList(Player player, String[] args) {
        int playerIndex;
        String codePath;
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /rc redeemed <code> [page]");
            return;
        }
        String codeName = args[1];
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (!codes.contains(codePath = "Codes." + codeName)) {
            player.sendMessage("\u00a7cThis code doesn't exist.");
            return;
        }
        List<String> redeemedPlayersUuids = this.plugin.getRedeemDataManager().getRedeemedPlayers(codeName);
        if (redeemedPlayersUuids.isEmpty()) {
            player.sendMessage(this.plugin.color("&cNo one has redeemed the code '&e" + codeName + "&c' yet."));
            return;
        }
        int page = 1;
        if (args.length >= 3) {
            try {
                page = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cInvalid page number.");
                return;
            }
        }
        int itemsPerPage = 10;
        int totalPages = (int)Math.ceil((double)redeemedPlayersUuids.size() / (double)itemsPerPage);
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages && totalPages > 0) {
            page = totalPages;
        }
        boolean hasNext = page < totalPages;
        boolean hasPrev = page > 1;
        TextComponent header = new TextComponent();
        if (hasPrev) {
            TextComponent prevButton = new TextComponent(this.plugin.color("&e\u00ab PREV"));
            prevButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc redeemed " + codeName + " " + (page - 1)));
            prevButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Go to Page " + (page - 1)).color(ChatColor.YELLOW).create()));
            header.addExtra((BaseComponent)prevButton);
        } else {
            header.addExtra(this.plugin.color("  &7\u00ab PREV  "));
        }
        header.addExtra(this.plugin.color(String.format(" &d&lPlayers Redeemed &r&d- Page %d/%d ", page, totalPages)));
        if (hasNext) {
            TextComponent nextButton = new TextComponent(this.plugin.color("&aNEXT \u00bb"));
            nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc redeemed " + codeName + " " + (page + 1)));
            nextButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Go to Page " + (page + 1)).color(ChatColor.GREEN).create()));
            header.addExtra((BaseComponent)nextButton);
        } else {
            header.addExtra(this.plugin.color("  &7NEXT \u00bb"));
        }
        player.sendMessage(this.plugin.color(" "));
        player.sendMessage(this.plugin.color("&e&m                                                                       "));
        player.spigot().sendMessage((BaseComponent)header);
        player.sendMessage(this.plugin.color(" "));
        int startIndex = (page - 1) * itemsPerPage;
        for (int i = 0; i < itemsPerPage && (playerIndex = startIndex + i) < redeemedPlayersUuids.size(); ++i) {
            String playerUuidString = redeemedPlayersUuids.get(playerIndex);
            try {
                UUID playerUuid = UUID.fromString(playerUuidString);
                String playerName = Bukkit.getOfflinePlayer((UUID)playerUuid).getName();
                if (playerName == null) {
                    playerName = playerUuidString;
                }
                player.sendMessage(this.plugin.color(String.format("&b%d: &7%s", playerIndex + 1, playerName)));
                continue;
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(this.plugin.color(String.format("&b%d: &cInvalid Data: %s", playerIndex + 1, playerUuidString)));
            }
        }
        player.sendMessage(this.plugin.color("&e&m                                                                       "));
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(Arrays.asList("reload", "create", "remove", "addreward", "removereward", "help", "list", "version", "show", "rewards", "redeemed", "gui", "review"));
        }
        if (args.length == 2) {
            FileConfiguration codes;
            String action = args[0].toLowerCase();
            List<String> codeCommands = Arrays.asList("remove", "addreward", "removereward", "show", "rewards", "redeemed");
            if (codeCommands.contains(action) && (codes = this.plugin.getCodesConfig()).isConfigurationSection("Codes")) {
                String currentArg = args[1].toLowerCase();
                ArrayList<String> matchingCodes = new ArrayList<String>();
                for (String codeName : codes.getConfigurationSection("Codes").getKeys(false)) {
                    if (!codeName.toLowerCase().startsWith(currentArg)) continue;
                    matchingCodes.add(codeName);
                }
                return matchingCodes;
            }
        }
        return new ArrayList<String>();
    }
}

