/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class VersionSupportChecker {
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.21.x", "1.20.2+");
    private final JavaPlugin plugin;

    public VersionSupportChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isVersionSupported() {
        String version = this.getServerVersion();
        for (String pattern : SUPPORTED_VERSIONS) {
            if (!this.matchesVersionPattern(version, pattern)) continue;
            return true;
        }
        return false;
    }

    public String getServerVersion() {
        String bukkitVersion = Bukkit.getBukkitVersion();
        int dashIndex = bukkitVersion.indexOf(45);
        if (dashIndex > 0) {
            return bukkitVersion.substring(0, dashIndex);
        }
        return bukkitVersion;
    }

    public void checkVersion() {
        String currentVersion = this.getServerVersion();
        boolean supported = this.isVersionSupported();
        if (!supported) {
            this.plugin.getLogger().warning("========================================");
            this.plugin.getLogger().warning("UNSUPPORTED MINECRAFT VERSION DETECTED!");
            this.plugin.getLogger().warning("Current version: " + currentVersion);
            this.plugin.getLogger().warning("Supported versions: " + String.join((CharSequence)", ", SUPPORTED_VERSIONS));
            this.plugin.getLogger().warning("This version is not officially supported.");
            this.plugin.getLogger().warning("Some features may not work properly.");
            this.plugin.getLogger().warning("Please look for a supported version at:");
            this.plugin.getLogger().warning("https://modrinth.com/plugin/redeemcodes");
            this.plugin.getLogger().warning("or contact developer");
            this.plugin.getLogger().warning("========================================");
        } else {
            this.plugin.getLogger().info("Server version " + currentVersion + " is supported \u2713");
        }
    }

    public List<String> getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    private boolean matchesVersionPattern(String version, String pattern) {
        if (pattern.endsWith(".x")) {
            String baseVersion = pattern.substring(0, pattern.length() - 2);
            return version.startsWith(baseVersion);
        }
        if (pattern.endsWith("+")) {
            String basePattern = pattern.substring(0, pattern.length() - 1);
            String[] baseParts = basePattern.split("\\.");
            if (baseParts.length < 2) {
                return false;
            }
            String[] versionParts = version.split("\\.");
            if (versionParts.length < 2) {
                return false;
            }
            if (!versionParts[0].equals(baseParts[0]) || !versionParts[1].equals(baseParts[1])) {
                return false;
            }
            if (baseParts.length >= 3) {
                try {
                    int minSubVersion = Integer.parseInt(baseParts[2]);
                    if (versionParts.length >= 3) {
                        int actualSubVersion = Integer.parseInt(versionParts[2]);
                        return actualSubVersion >= minSubVersion;
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }
        return version.equals(pattern);
    }
}

