/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.redeem.redeemcodes.Redeemcodes;
import com.redeem.redeemcodes.gui.AdminPanelGUI;
import com.redeem.redeemcodes.gui.CodeEditorGUI;
import com.redeem.redeemcodes.gui.MainGUI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class CreateCodeHandler
implements Listener {
    private final Redeemcodes plugin;
    private final Set<UUID> awaitingInput = new HashSet<UUID>();
    private final Set<UUID> awaitingDuplicationInput = new HashSet<UUID>();
    private final Set<UUID> awaitingReviewInput = new HashSet<UUID>();
    private String selectedCodeForDuplication = null;

    public CreateCodeHandler(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    public void startCodeCreation(Player player) {
        this.awaitingInput.add(player.getUniqueId());
        player.closeInventory();
        player.sendMessage("\u00a7aPlease type the name for your new code in chat.");
        player.sendMessage("\u00a77Type 'cancel' to abort.");
    }

    public void startDuplication(Player player, String selectedCode) {
        this.awaitingDuplicationInput.add(player.getUniqueId());
        this.selectedCodeForDuplication = selectedCode;
        player.closeInventory();
        player.sendMessage("\u00a7aPlease type the name for the duplicated code in chat.");
        player.sendMessage("\u00a77Type 'cancel' to abort.");
    }

    public void startReviewInput(Player player) {
        this.awaitingReviewInput.add(player.getUniqueId());
        player.closeInventory();
        player.sendMessage("\u00a7aPlease type your review or feedback in chat.");
        player.sendMessage("\u00a77Type 'cancel' to abort.");
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.awaitingInput.contains(playerUUID)) {
            event.setCancelled(true);
            String input = event.getMessage().trim();
            if (input.equalsIgnoreCase("cancel")) {
                this.awaitingInput.remove(playerUUID);
                player.sendMessage("\u00a7cCode creation cancelled.");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.createCode(player, input));
            this.awaitingInput.remove(playerUUID);
            return;
        }
        if (this.awaitingDuplicationInput.contains(playerUUID)) {
            event.setCancelled(true);
            String input = event.getMessage().trim();
            if (input.equalsIgnoreCase("cancel")) {
                this.awaitingDuplicationInput.remove(playerUUID);
                this.selectedCodeForDuplication = null;
                player.sendMessage("\u00a7cCode duplication cancelled.");
                return;
            }
            if (!this.isValidCodeName(input)) {
                player.sendMessage("\u00a7cInvalid code name! Code names can only contain letters, numbers, and underscores.");
                return;
            }
            if (this.plugin.getCodesConfig().contains("Codes." + input)) {
                player.sendMessage("\u00a7cThat code name already exists!");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.duplicateCode(player, this.selectedCodeForDuplication, input));
            this.awaitingDuplicationInput.remove(playerUUID);
            this.selectedCodeForDuplication = null;
            return;
        }
        if (this.awaitingReviewInput.contains(playerUUID)) {
            event.setCancelled(true);
            String input = event.getMessage().trim();
            if (input.equalsIgnoreCase("cancel")) {
                this.awaitingReviewInput.remove(playerUUID);
                player.sendMessage("\u00a7cReview cancelled.");
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.sendReview(player, input));
            this.awaitingReviewInput.remove(playerUUID);
            return;
        }
        CodeEditorGUI editor = this.plugin.openEditorGUIs.get(player);
        if (editor != null) {
            editor.handleChatInput(event);
        }
    }

    private void createCode(Player player, String codeName) {
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (codes.contains("Codes." + codeName)) {
            player.sendMessage("\u00a7cThat code already exists!");
            return;
        }
        codes.set("Codes." + codeName + ".enabled", (Object)true);
        codes.set("Codes." + codeName + ".permisson.required", (Object)false);
        codes.set("Codes." + codeName + ".permisson.list", new ArrayList());
        codes.set("Codes." + codeName + ".redeem-limit.Type", (Object)"PLAYER");
        codes.set("Codes." + codeName + ".redeem-limit.Count", (Object)1);
        codes.set("Codes." + codeName + ".redeem-limit.Cooldown", (Object)0);
        codes.set("Codes." + codeName + ".expire-time", (Object)-1);
        codes.set("Codes." + codeName + ".Playerlist.Used", new ArrayList());
        codes.set("Codes." + codeName + ".Playerlist.Blacklist.Type", (Object)"ENABLED");
        codes.set("Codes." + codeName + ".Playerlist.Blacklist.List", new ArrayList());
        codes.set("Codes." + codeName + ".rewards", new ArrayList());
        this.plugin.saveCodesConfig();
        player.sendMessage("\u00a7aCode \u00a7e" + codeName + " \u00a7ahas been created!");
        MainGUI.open(player);
    }

    private void duplicateCode(Player player, String sourceCode, String newCodeName) {
        FileConfiguration codes = this.plugin.getCodesConfig();
        String sourcePath = "Codes." + sourceCode;
        String newPath = "Codes." + newCodeName;
        codes.set(newPath + ".enabled", (Object)codes.getBoolean(sourcePath + ".enabled", true));
        codes.set(newPath + ".permisson.required", (Object)codes.getBoolean(sourcePath + ".permisson.required", false));
        codes.set(newPath + ".permisson.list", new ArrayList(codes.getStringList(sourcePath + ".permisson.list")));
        codes.set(newPath + ".redeem-limit.Type", (Object)codes.getString(sourcePath + ".redeem-limit.Type", "PLAYER"));
        codes.set(newPath + ".redeem-limit.Count", (Object)codes.getInt(sourcePath + ".redeem-limit.Count", 1));
        codes.set(newPath + ".redeem-limit.Cooldown", (Object)codes.getInt(sourcePath + ".redeem-limit.Cooldown", 0));
        int initialExpireTime = codes.getInt(sourcePath + ".expire-time", -1);
        codes.set(newPath + ".expire-time", (Object)initialExpireTime);
        codes.set(newPath + ".Playerlist.Used", new ArrayList());
        codes.set(newPath + ".Playerlist.Blacklist.Type", (Object)"ENABLED");
        codes.set(newPath + ".Playerlist.Blacklist.List", new ArrayList());
        codes.set(newPath + ".rewards", new ArrayList(codes.getStringList(sourcePath + ".rewards")));
        this.plugin.saveCodesConfig();
        player.sendMessage("\u00a7aCode \u00a7e" + newCodeName + " \u00a7ahas been created as a duplicate of \u00a7e" + sourceCode + "\u00a7a!");
        AdminPanelGUI.open(player, this.plugin);
    }

    private boolean isValidCodeName(String name) {
        return name.matches("^[a-zA-Z0-9_]+$");
    }

    private void sendReview(Player player, String reviewMessage) {
        player.closeInventory();
        player.performCommand("rc review " + reviewMessage);
    }
}

