/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.redeem.redeemcodes.Redeemcodes;
import com.redeem.redeemcodes.gui.CodeEditorGUI;
import com.redeem.redeemcodes.gui.CodesListGUI;
import com.redeem.redeemcodes.gui.HeadManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ExpiredCodesListGUI {
    private final Redeemcodes plugin;
    private final CodesListGUI parentGUI;
    private List<String> codes;
    private int page = 0;
    private static final int CODES_PER_PAGE = 28;
    private static final String pro = "\u00a7x\u00a7F\u00a7F\u00a77\u00a70\u00a77\u00a70\u00a7l| ";
    private static final String titleColor = "\u00a7c";

    public ExpiredCodesListGUI(Redeemcodes plugin, CodesListGUI parentGUI) {
        this.plugin = plugin;
        this.parentGUI = parentGUI;
    }

    public void open(Player player) {
        ItemStack pageDisplay;
        ItemMeta pageMeta;
        int index;
        int end;
        int start;
        this.codes = new ArrayList<String>(this.plugin.getExpirationManager().getExpiredCodes());
        Inventory inv = Bukkit.createInventory((InventoryHolder)null, (int)54, (String)"\u00a7cExpired Redeem Codes");
        ItemStack border = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta borderMeta = border.getItemMeta();
        if (borderMeta != null) {
            borderMeta.setDisplayName(" ");
        }
        border.setItemMeta(borderMeta);
        for (start = 0; start < 54; ++start) {
            end = start / 9;
            index = start % 9;
            if (end != 0 && end != 5 && index != 0 && index != 8) continue;
            inv.setItem(start, border);
        }
        start = this.page * 28;
        end = Math.min(start + 28, this.codes.size());
        index = 0;
        for (int row = 1; row <= 4; ++row) {
            for (int col = 1; col <= 7 && start + index < end; ++col) {
                int slot = row * 9 + col;
                inv.setItem(slot, this.createCodeHead(this.codes.get(start + index)));
                ++index;
            }
        }
        if (this.page > 0) {
            inv.setItem(45, HeadManager.getHead("PREV_PAGE", "\u00a77Previous Page", new String[0]));
        }
        inv.setItem(49, HeadManager.getHead("BACK", "\u00a7cGo Back", "\u00a77Click to go back to code list"));
        if (end < this.codes.size()) {
            inv.setItem(53, HeadManager.getHead("NEXT_PAGE", "\u00a77Next Page", new String[0]));
        }
        if ((pageMeta = (pageDisplay = new ItemStack(Material.PAPER)).getItemMeta()) != null) {
            pageMeta.setDisplayName("Page: \u00a7c" + (this.page + 1) + "/" + ((this.codes.size() - 1) / 28 + 1));
            pageDisplay.setItemMeta(pageMeta);
        }
        inv.setItem(48, pageDisplay);
        player.openInventory(inv);
    }

    private ItemStack createCodeHead(String code) {
        ItemStack head = HeadManager.getHead("EXPIRED_CODE_ITEM", titleColor + code, new String[0]);
        ItemMeta meta = head.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77\u1d04\u029f\u026a\u1d04\u1d0b \u1d1b\u1d0f \u1d07\u1d05\u026a\u1d1b \u1d00\u0274\u1d05 \u0280\u1d07\u1d00\u1d04\u1d1b\u026a\u1d20\u1d00\u1d1b\u1d07");
            meta.setLore(lore);
            head.setItemMeta(meta);
        }
        return head;
    }

    public void handleClick(InventoryClickEvent event, Player player) {
        if (!event.getView().getTitle().contains("Expired Redeem Codes")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta() || !clickedItem.getItemMeta().hasDisplayName()) {
            return;
        }
        String itemName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
        if (itemName.equals("Go Back")) {
            player.closeInventory();
            this.plugin.openEditorGUIs.remove(player);
            if (this.parentGUI != null) {
                this.plugin.openCodeGUIs.put(player, this.parentGUI);
                this.parentGUI.open(player);
            }
        } else if (itemName.equals("Next Page")) {
            if ((this.page + 1) * 28 < this.codes.size()) {
                ++this.page;
                this.open(player);
            }
        } else if (itemName.equals("Previous Page")) {
            if (this.page > 0) {
                --this.page;
                this.open(player);
            }
        } else if (this.codes.contains(itemName)) {
            CodeEditorGUI editor = new CodeEditorGUI(this.plugin, itemName, this.parentGUI);
            this.plugin.openEditorGUIs.put(player, editor);
            editor.open(player);
        }
    }
}

