/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.redeem.redeemcodes.Redeemcodes;
import com.redeem.redeemcodes.gui.AdminPanelGUI;
import com.redeem.redeemcodes.gui.CodeEditorGUI;
import com.redeem.redeemcodes.gui.CodesListGUI;
import com.redeem.redeemcodes.gui.CreateCodeHandler;
import com.redeem.redeemcodes.gui.ExpiredCodesListGUI;
import com.redeem.redeemcodes.gui.MainGUI;
import com.redeem.redeemcodes.gui.SelectCodeListGUI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;

public class GUIListener
implements Listener {
    private final Redeemcodes plugin;
    private final CreateCodeHandler createHandler;

    public GUIListener(Redeemcodes plugin, CreateCodeHandler createHandler) {
        this.plugin = plugin;
        this.createHandler = createHandler;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (title.contains("Redeem Codes") && !title.contains("Expired")) {
            CodesListGUI gui = this.plugin.openCodeGUIs.get(player);
            if (gui != null) {
                gui.handleClick(event, player);
            }
        } else if (title.contains("Edit Code:")) {
            CodeEditorGUI editor = this.plugin.openEditorGUIs.get(player);
            if (editor != null) {
                editor.handleClick(event, player);
            }
        } else if (title.contains("Expired Redeem Codes")) {
            ExpiredCodesListGUI gui = this.plugin.openExpiredCodeGUIs.get(player);
            if (gui != null) {
                gui.handleClick(event, player);
            }
        } else if (title.contains("Select: Code List")) {
            SelectCodeListGUI gui = this.plugin.openSelectCodeGUIs.get(player);
            if (gui != null) {
                gui.handleClick(event, player);
            }
        } else if (title.equals(String.valueOf(ChatColor.DARK_PURPLE) + "Admin Panel")) {
            AdminPanelGUI.handleClick(event, this.plugin);
        } else if (title.equals(String.valueOf(ChatColor.DARK_PURPLE) + "RedeemCodes Menu")) {
            MainGUI.handleClick(event, this.plugin, this.createHandler);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        if (title.contains("Edit Code:")) {
            CodeEditorGUI editor = this.plugin.openEditorGUIs.get(player);
            if (editor != null) {
                editor.cancelUpdateTask();
            }
        } else if (title.contains("Redeem Codes") && !title.contains("Expired")) {
            this.plugin.openCodeGUIs.remove(player);
        } else if (title.contains("Expired Redeem Codes")) {
            this.plugin.openExpiredCodeGUIs.remove(player);
        } else if (title.contains("Select: Code List")) {
            this.plugin.openSelectCodeGUIs.remove(player);
        }
    }
}

