/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import com.redeem.redeemcodes.Redeemcodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class RedeemCodesCommand
implements CommandExecutor,
TabCompleter {
    private final Redeemcodes plugin;

    public RedeemCodesCommand(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    private void playSound(Player player, String path) {
        String soundName = this.plugin.getConfig().getString(path);
        if (soundName == null) {
            return;
        }
        try {
            player.playSound(player.getLocation(), Sound.valueOf((String)soundName.toUpperCase()), 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getMessage(String key) {
        return this.plugin.color(this.plugin.getPrefix() + this.plugin.getConfig().getString("messages." + key, "&cMessage not found: " + key));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use admin commands.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.isOp() && !player.hasPermission("redeemcodes.admin")) {
            player.sendMessage(this.getMessage("no-permission"));
            this.playSound(player, "sounds.failure");
            return true;
        }
        if (args.length < 1) {
            this.sendHelp(player);
            return true;
        }
        String action = args[0].toLowerCase();
        FileConfiguration codes = this.plugin.getCodesConfig();
        switch (action) {
            case "reload": {
                this.plugin.reloadConfig();
                this.plugin.reloadCodesConfig();
                player.sendMessage(this.getMessage("reload-success"));
                this.playSound(player, "sounds.success");
                break;
            }
            case "create": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /rc create <code>");
                    return true;
                }
                String codeCreate = args[1];
                if (codes.contains("Codes." + codeCreate)) {
                    player.sendMessage(this.getMessage("code-exists"));
                    this.playSound(player, "sounds.failure");
                    break;
                }
                codes.set("Codes." + codeCreate + ".enabled", (Object)true);
                codes.set("Codes." + codeCreate + ".permisson.required", (Object)false);
                codes.set("Codes." + codeCreate + ".permisson.list", new ArrayList());
                codes.set("Codes." + codeCreate + ".redeem-limit.Type", (Object)"PLAYER");
                codes.set("Codes." + codeCreate + ".redeem-limit.Count", (Object)1);
                codes.set("Codes." + codeCreate + ".redeem-limit.Cooldown", (Object)0);
                codes.set("Codes." + codeCreate + ".Playerlist.Used", new ArrayList());
                codes.set("Codes." + codeCreate + ".Playerlist.Blacklist.Type", (Object)"ENABLED");
                codes.set("Codes." + codeCreate + ".Playerlist.Blacklist.List", new ArrayList());
                codes.set("Codes." + codeCreate + ".rewards", new ArrayList());
                this.plugin.saveCodesConfig();
                player.sendMessage(this.getMessage("code-created").replace("%code%", codeCreate));
                player.sendMessage(this.plugin.color("&e[!] In-game editor is not yet available. Please edit codes.yml manually."));
                this.playSound(player, "sounds.success");
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    player.sendMessage("\u00a7cUsage: /rc remove <code>");
                    return true;
                }
                String codeRemove = args[1];
                if (!codes.contains("Codes." + codeRemove)) {
                    player.sendMessage("\u00a7cThis code doesn't exist.");
                    return true;
                }
                codes.set("Codes." + codeRemove, null);
                this.plugin.saveCodesConfig();
                player.sendMessage(this.plugin.color("&aCode removed: &c" + codeRemove));
                this.playSound(player, "sounds.success");
                break;
            }
            case "addreward": {
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /rc addreward <code> <reward>");
                    return true;
                }
                String codeAdd = args[1];
                if (!codes.contains("Codes." + codeAdd)) {
                    player.sendMessage("\u00a7cThis code doesn't exist.");
                    return true;
                }
                String reward = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                List rewards = codes.getStringList("Codes." + codeAdd + ".rewards");
                rewards.add(reward);
                codes.set("Codes." + codeAdd + ".rewards", (Object)rewards);
                this.plugin.saveCodesConfig();
                player.sendMessage(this.getMessage("reward-added").replace("%code%", codeAdd).replace("%id%", String.valueOf(rewards.size() - 1)));
                this.playSound(player, "sounds.success");
                break;
            }
            case "removereward": {
                if (args.length < 3) {
                    player.sendMessage("\u00a7cUsage: /rc removereward <code> <id>");
                    return true;
                }
                String codeRemoveReward = args[1];
                if (!codes.contains("Codes." + codeRemoveReward)) {
                    player.sendMessage("\u00a7cThis code doesn't exist.");
                    return true;
                }
                try {
                    int id = Integer.parseInt(args[2]);
                    List rewards = codes.getStringList("Codes." + codeRemoveReward + ".rewards");
                    if (id >= 0 && id < rewards.size()) {
                        rewards.remove(id);
                        codes.set("Codes." + codeRemoveReward + ".rewards", (Object)rewards);
                        this.plugin.saveCodesConfig();
                        player.sendMessage(this.getMessage("reward-removed").replace("%id%", String.valueOf(id)));
                        this.playSound(player, "sounds.success");
                        break;
                    }
                    player.sendMessage("\u00a7cReward ID doesn't exist.");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid reward ID.");
                }
                break;
            }
            case "help": {
                this.sendHelp(player);
                break;
            }
            case "list": {
                this.sendCodeList(player);
                break;
            }
            case "version": {
                player.sendMessage(this.plugin.color("&bRedeemCodes Version: &f" + this.plugin.getDescription().getVersion()));
                break;
            }
            case "show": {
                this.showCodeDetails(player, args);
                break;
            }
            default: {
                player.sendMessage(this.getMessage("unknown-action").replace("%action%", action));
                this.playSound(player, "sounds.failure");
            }
        }
        return true;
    }

    private void showCodeDetails(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /rc show <code>");
            return;
        }
        String code = args[1];
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (!codes.contains("Codes." + code)) {
            player.sendMessage("\u00a7cThis code doesn't exist.");
            return;
        }
        player.sendMessage(this.plugin.color("&d---- &bCode Details: &f" + code + " &d----"));
        player.sendMessage(this.plugin.color("&7Enabled: " + (codes.getBoolean("Codes." + code + ".enabled", true) ? "&aTrue" : "&cFalse")));
        player.sendMessage(this.plugin.color("&7Permission Required: " + (codes.getBoolean("Codes." + code + ".permisson.required", false) ? "&aYes" : "&cNo")));
        player.sendMessage(this.plugin.color("&7Cooldown: &b" + codes.getInt("Codes." + code + ".redeem-limit.Cooldown", 0) + " minutes"));
        player.sendMessage(this.plugin.color("&7Redeem Type: &b" + codes.getString("Codes." + code + ".redeem-limit.Type", "PLAYER")));
        player.sendMessage(this.plugin.color("&7Redeem Limit: &b" + codes.getInt("Codes." + code + ".redeem-limit.Count", 1)));
        player.sendMessage(this.plugin.color("&7Rewards:"));
        List rewards = codes.getStringList("Codes." + code + ".rewards");
        if (rewards.isEmpty()) {
            player.sendMessage(this.plugin.color("&c- No rewards set."));
        } else {
            for (int i = 0; i < rewards.size(); ++i) {
                player.sendMessage(this.plugin.color("&b  #" + i + ": &7" + (String)rewards.get(i)));
            }
        }
    }

    private void sendHelp(Player player) {
        player.sendMessage(this.plugin.color("&d---- &bRedeemCodes Help &d----"));
        player.sendMessage(this.plugin.color("&b/rc create <code> &7- Create a new code"));
        player.sendMessage(this.plugin.color("&b/rc remove <code> &7- Remove a code"));
        player.sendMessage(this.plugin.color("&b/rc addreward <code> <command> &7- Add a reward to a code"));
        player.sendMessage(this.plugin.color("&b/rc removereward <code> <id> &7- Remove a reward by ID"));
        player.sendMessage(this.plugin.color("&b/rc list &7- List all codes"));
        player.sendMessage(this.plugin.color("&b/rc reload &7- Reload plugin configs"));
        player.sendMessage(this.plugin.color("&b/rc version &7- View plugin version"));
    }

    private void sendCodeList(Player player) {
        FileConfiguration codes = this.plugin.getCodesConfig();
        Set codeNames = codes.getConfigurationSection("Codes").getKeys(false);
        player.sendMessage(this.plugin.color("&d---- &bList of Existing Codes &d----"));
        for (String code : codeNames) {
            boolean enabled = codes.getBoolean("Codes." + code + ".enabled", true);
            TextComponent component = new TextComponent(this.plugin.color((enabled ? "&a" : "&c") + "\u27a4 " + code));
            component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/rc show " + code));
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to view details").create()));
            player.spigot().sendMessage((BaseComponent)component);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload", "create", "remove", "addreward", "removereward", "help", "list", "version");
        }
        return new ArrayList<String>();
    }
}

