/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import com.redeem.redeemcodes.RedeemDataManager;
import com.redeem.redeemcodes.Redeemcodes;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class RedeemCommand
implements CommandExecutor {
    private final Redeemcodes plugin;

    public RedeemCommand(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    private String parsePlaceholders(String input, Player player) {
        input = input.replace("%player%", player.getName());
        input = input.replace("%uuid%", player.getUniqueId().toString());
        input = input.replace("%displayname%", player.getDisplayName());
        input = input.replace("%world%", player.getWorld().getName());
        Pattern randomPattern = Pattern.compile("%random-(\\d+)-(\\d+)%");
        Matcher matcher = randomPattern.matcher(input);
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int min = Integer.parseInt(matcher.group(1));
            int max = Integer.parseInt(matcher.group(2));
            int result = random.nextInt(max - min + 1) + min;
            matcher.appendReplacement(sb, String.valueOf(result));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void playSound(Player player, String path) {
        String soundName = this.plugin.getConfig().getString(path);
        if (soundName == null) {
            return;
        }
        try {
            player.playSound(player.getLocation(), Sound.valueOf((String)soundName.toUpperCase()), 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendMessage(Player player, String key) {
        String message = this.plugin.getConfig().getString("messages." + key, "&cMessage not found: " + key);
        player.sendMessage(this.plugin.color(this.plugin.getPrefix() + message));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long cooldownMillis;
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can redeem codes!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            this.sendMessage(player, "usage");
            this.playSound(player, "sounds.failure");
            return true;
        }
        String code = args[0];
        FileConfiguration codes = this.plugin.getCodesConfig();
        if (!codes.contains("Codes." + code)) {
            this.sendMessage(player, "not-exist");
            this.playSound(player, "sounds.failure");
            return true;
        }
        if (!codes.getBoolean("Codes." + code + ".enabled", true)) {
            this.sendMessage(player, "code-disabled");
            this.playSound(player, "sounds.failure");
            return true;
        }
        if (codes.getBoolean("Codes." + code + ".permisson.required", false)) {
            List perms = codes.getStringList("Codes." + code + ".permisson.list");
            boolean hasPermission = perms.stream().anyMatch(arg_0 -> ((Player)player).hasPermission(arg_0));
            if (!hasPermission) {
                this.sendMessage(player, "no-permission");
                this.playSound(player, "sounds.failure");
                return true;
            }
        }
        String type = codes.getString("Codes." + code + ".Playerlist.Blacklist.Type", "ENABLED");
        List blacklisted = codes.getStringList("Codes." + code + ".Playerlist.Blacklist.List");
        if (type.equalsIgnoreCase("ENABLED") && blacklisted.contains(player.getName()) || type.equalsIgnoreCase("REVERSE") && !blacklisted.contains(player.getName())) {
            this.sendMessage(player, "blacklisted");
            this.playSound(player, "sounds.failure");
            return true;
        }
        String limitType = codes.getString("Codes." + code + ".redeem-limit.Type", "PLAYER");
        int limitCount = codes.getInt("Codes." + code + ".redeem-limit.Count", -1);
        int cooldownMinutes = codes.getInt("Codes." + code + ".redeem-limit.Cooldown", 0);
        RedeemDataManager dataManager = this.plugin.getRedeemDataManager();
        int playerUses = dataManager.getPlayerUses(code, player.getUniqueId());
        long lastRedeemTime = dataManager.getLastRedeemTime(code, player.getUniqueId());
        long currentTime = System.currentTimeMillis();
        if (limitType.equalsIgnoreCase("PLAYER")) {
            if (limitCount != -1 && playerUses >= limitCount) {
                this.sendMessage(player, "already-used");
                this.playSound(player, "sounds.failure");
                return true;
            }
        } else if (limitType.equalsIgnoreCase("CODE")) {
            if (playerUses > 0) {
                this.sendMessage(player, "already-used");
                this.playSound(player, "sounds.failure");
                return true;
            }
            if (limitCount <= 0) {
                this.sendMessage(player, "out-of-stock");
                this.playSound(player, "sounds.failure");
                return true;
            }
        }
        if (cooldownMinutes > 0 && currentTime - lastRedeemTime < (cooldownMillis = (long)cooldownMinutes * 60L * 1000L)) {
            long remaining = (cooldownMillis - (currentTime - lastRedeemTime)) / 1000L;
            long minutes = remaining / 60L;
            long seconds = remaining % 60L;
            String formatted = minutes + "m " + seconds + "s";
            String msg = codes.getString("Codes." + code + ".redeem-limit.Cooldown-message", "&cWait %Cooldown%");
            player.sendMessage(this.plugin.color(this.plugin.getPrefix() + msg.replace("%Cooldown%", formatted)));
            this.playSound(player, "sounds.failure");
            return true;
        }
        List rewards = codes.getStringList("Codes." + code + ".rewards");
        for (String reward : rewards) {
            String parsed = this.parsePlaceholders(reward, player);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsed);
        }
        dataManager.addGlobalUse(code);
        dataManager.setPlayerUses(code, player.getUniqueId(), playerUses + 1);
        dataManager.setLastRedeemTime(code, player.getUniqueId(), currentTime);
        if (limitType.equalsIgnoreCase("CODE")) {
            codes.set("Codes." + code + ".redeem-limit.Count", (Object)(limitCount - 1));
            this.plugin.saveCodesConfig();
        }
        this.sendMessage(player, "redeem-success");
        this.playSound(player, "sounds.success");
        return true;
    }
}

