/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class RedeemDataManager {
    private final JavaPlugin plugin;
    private File file;
    private FileConfiguration data;

    public RedeemDataManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.createFile();
    }

    private void createFile() {
        this.file = new File(this.plugin.getDataFolder(), "redeemdata.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create redeemdata.yml!");
                e.printStackTrace();
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void saveFile() {
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save redeemdata.yml!");
            e.printStackTrace();
        }
    }

    public int getPlayerUses(String codeName, UUID uuid) {
        return this.data.getInt("codes." + codeName + ".players." + String.valueOf(uuid) + ".used-times", 0);
    }

    public void setPlayerUses(String codeName, UUID uuid, int uses) {
        this.data.set("codes." + codeName + ".players." + String.valueOf(uuid) + ".used-times", (Object)uses);
        this.saveFile();
    }

    public long getLastRedeemTime(String codeName, UUID uuid) {
        return this.data.getLong("codes." + codeName + ".players." + String.valueOf(uuid) + ".last-redeem", 0L);
    }

    public void setLastRedeemTime(String codeName, UUID uuid, long time) {
        this.data.set("codes." + codeName + ".players." + String.valueOf(uuid) + ".last-redeem", (Object)time);
        this.saveFile();
    }

    public void addGlobalUse(String codeName) {
        int count = this.data.getInt("codes." + codeName + ".global-uses", 0);
        this.data.set("codes." + codeName + ".global-uses", (Object)(count + 1));
        this.saveFile();
    }
}

