/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import com.redeem.redeemcodes.RedeemDataManager;
import com.redeem.redeemcodes.Redeemcodes;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CodeExpirationManager {
    private final Redeemcodes plugin;
    private final RedeemDataManager dataManager;
    private final Map<String, Long> activeTimers = new ConcurrentHashMap<String, Long>();
    private final Set<String> expiredCodes = new HashSet<String>();
    private BukkitTask timerTask;

    public CodeExpirationManager(Redeemcodes plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getRedeemDataManager();
        this.loadExpirations();
        this.startTimer();
    }

    private void loadExpirations() {
        FileConfiguration data = this.dataManager.getData();
        if (!data.isConfigurationSection("codes")) {
            return;
        }
        long now = System.currentTimeMillis();
        for (String codeName : data.getConfigurationSection("codes").getKeys(false)) {
            long timestamp = data.getLong("codes." + codeName + ".expiration-timestamp", -1L);
            if (timestamp == -1L) continue;
            if (timestamp <= now) {
                this.expiredCodes.add(codeName);
                continue;
            }
            this.activeTimers.put(codeName, timestamp);
        }
    }

    private void startTimer() {
        this.timerTask = new BukkitRunnable(){

            public void run() {
                if (CodeExpirationManager.this.activeTimers.isEmpty()) {
                    return;
                }
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<String, Long>> iterator = CodeExpirationManager.this.activeTimers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Long> entry = iterator.next();
                    if (now < entry.getValue()) continue;
                    String codeName = entry.getKey();
                    iterator.remove();
                    CodeExpirationManager.this.expiredCodes.add(codeName);
                    CodeExpirationManager.this.plugin.getLogger().info("Code '" + codeName + "' has expired.");
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 20L, 20L);
    }

    public void stopTimer() {
        if (this.timerTask != null && !this.timerTask.isCancelled()) {
            this.timerTask.cancel();
        }
    }

    public boolean isExpired(String codeName) {
        return this.expiredCodes.contains(codeName);
    }

    public long getRemainingTime(String codeName) {
        Long timestamp = this.activeTimers.get(codeName);
        if (timestamp == null) {
            return -1L;
        }
        return Math.max(0L, timestamp - System.currentTimeMillis());
    }

    public void setExpiration(String codeName, long durationSeconds) {
        FileConfiguration codesConfig = this.plugin.getCodesConfig();
        if (durationSeconds == -1L) {
            this.activeTimers.remove(codeName);
            this.expiredCodes.remove(codeName);
            this.dataManager.setExpirationTimestamp(codeName, -1L);
            codesConfig.set("Codes." + codeName + ".expire-time", (Object)-1);
        } else {
            long timestamp = System.currentTimeMillis() + durationSeconds * 1000L;
            this.activeTimers.put(codeName, timestamp);
            this.expiredCodes.remove(codeName);
            this.dataManager.setExpirationTimestamp(codeName, timestamp);
            codesConfig.set("Codes." + codeName + ".expire-time", (Object)durationSeconds);
        }
        this.plugin.saveCodesConfig();
    }

    public void reactivate(String codeName) {
        this.setExpiration(codeName, -1L);
    }

    public Set<String> getExpiredCodes() {
        return new HashSet<String>(this.expiredCodes);
    }
}

