/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class RedeemDataManager {
    private final JavaPlugin plugin;
    private File file;
    private FileConfiguration data;

    public RedeemDataManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.createFile();
    }

    private void createFile() {
        this.file = new File(this.plugin.getDataFolder(), "redeemdata.yml");
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create redeemdata.yml!");
                e.printStackTrace();
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public FileConfiguration getData() {
        return this.data;
    }

    public void saveFile() {
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save redeemdata.yml!");
            e.printStackTrace();
        }
    }

    public int getPlayerUses(String codeName, UUID uuid) {
        return this.data.getInt("codes." + codeName + ".players." + String.valueOf(uuid) + ".used-times", 0);
    }

    public void addPlayerUse(String codeName, UUID uuid) {
        int current = this.getPlayerUses(codeName, uuid);
        this.data.set("codes." + codeName + ".players." + String.valueOf(uuid) + ".used-times", (Object)(current + 1));
        this.saveFile();
    }

    public List<String> getRedeemedPlayers(String codeName) {
        String path = "codes." + codeName + ".players";
        if (this.data.isConfigurationSection(path)) {
            Set playerUUIDs = this.data.getConfigurationSection(path).getKeys(false);
            return new ArrayList<String>(playerUUIDs);
        }
        return Collections.emptyList();
    }

    public void resetPlayerUses(String codeName, UUID uuid) {
        this.data.set("codes." + codeName + ".players." + String.valueOf(uuid) + ".used-times", (Object)0);
        this.saveFile();
    }

    public long getLastRedeemTime(String codeName, UUID uuid) {
        return this.data.getLong("codes." + codeName + ".players." + String.valueOf(uuid) + ".last-redeem", 0L);
    }

    public void setLastRedeemTime(String codeName, UUID uuid, long time) {
        this.data.set("codes." + codeName + ".players." + String.valueOf(uuid) + ".last-redeem", (Object)time);
        this.saveFile();
    }

    public int getGlobalUses(String codeName) {
        return this.data.getInt("codes." + codeName + ".global-uses", 0);
    }

    public void addGlobalUse(String codeName) {
        int current = this.getGlobalUses(codeName);
        this.data.set("codes." + codeName + ".global-uses", (Object)(current + 1));
        this.saveFile();
    }

    public void resetGlobalUses(String codeName) {
        this.data.set("codes." + codeName + ".global-uses", (Object)0);
        this.saveFile();
    }

    public long getExpirationTimestamp(String codeName) {
        return this.data.getLong("codes." + codeName + ".expiration-timestamp", -1L);
    }

    public void setExpirationTimestamp(String codeName, long timestamp) {
        this.data.set("codes." + codeName + ".expiration-timestamp", (Object)timestamp);
        this.saveFile();
    }

    public boolean hasCooldown(String codeName, UUID uuid, long cooldownMillis) {
        long last = this.getLastRedeemTime(codeName, uuid);
        return System.currentTimeMillis() - last < cooldownMillis;
    }
}

