/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class VersionSupportChecker {
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8", "1.21.9", "1.21.10");
    private final JavaPlugin plugin;

    public VersionSupportChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isVersionSupported() {
        String version = this.getServerVersion();
        return SUPPORTED_VERSIONS.contains(version);
    }

    public String getServerVersion() {
        String bukkitVersion = Bukkit.getBukkitVersion();
        int dashIndex = bukkitVersion.indexOf(45);
        if (dashIndex > 0) {
            return bukkitVersion.substring(0, dashIndex);
        }
        return bukkitVersion;
    }

    public void checkVersion() {
        String currentVersion = this.getServerVersion();
        boolean supported = this.isVersionSupported();
        if (!supported) {
            this.plugin.getLogger().warning("========================================");
            this.plugin.getLogger().warning("UNSUPPORTED MINECRAFT VERSION DETECTED!");
            this.plugin.getLogger().warning("Current version: " + currentVersion);
            this.plugin.getLogger().warning("Supported versions: " + String.join((CharSequence)", ", SUPPORTED_VERSIONS));
            this.plugin.getLogger().warning("This version is not officially supported.");
            this.plugin.getLogger().warning("Some features may not work properly.");
            this.plugin.getLogger().warning("Please look for a supported version at:");
            this.plugin.getLogger().warning("https://modrinth.com/plugin/redeemcodes");
            this.plugin.getLogger().warning("or contact developer");
            this.plugin.getLogger().warning("========================================");
        } else {
            this.plugin.getLogger().info("Server version " + currentVersion + " is supported \u2713");
        }
    }

    public List<String> getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }
}

